<?php

namespace App;

use Illuminate\Support\Facades\Mail,
	Illuminate\Support\Str,
	Carbon\Carbon;

Class Helper
{
	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param date $date
	 * --------------------------------------------------
	 */
	static public function getDate($date = null)
	{
		$result = [
			'date' => $date,
			'yy' => Carbon::create($date)->format('Y'),
			'mm' => Carbon::create($date)->format('n'),
			'dd' => Carbon::create($date)->format('j'),
			'hh' => Carbon::create($date)->format('H'),
			'ii' => Carbon::create($date)->format('i'),
		];

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $yy
	 * @param int $mm
	 * @param int $dd
	 * --------------------------------------------------
	 */
	static public function createDate($yy, $mm, $dd)
	{
		$result = Carbon::create(
			$yy,
			$mm,
			$dd,
			0,
			0,
			0
		)->toDateString();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $year
	 * @param int $month
	 * @param int $day
	 * @param int $hour
	 * @param int $minute
	 * @param int $second
	 * --------------------------------------------------
	 */
	static public function createDateTime($yy, $mm, $dd, $hh = 0, $ii = 0, $ss = 0)
	{
		$result = Carbon::create(
			$yy,
			$mm,
			$dd,
			$hh,
			$ii,
			$ss
		)->toDateTimeString();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $from
	 * @param int $to
	 * --------------------------------------------------
	 */
	static public function getYearList($from = null, $to = null)
	{
		$result = [];

		$from = (is_null($from)) ? Carbon::now()->subYear()->format('Y') : $from;
		$to = (is_null($to)) ? Carbon::now()->addYear()->format('Y') : $to;

		for($i = $from; $i <= $to; $i++) {
			$result[$i] = implode('', [
				$i,
				//__("lang.date.yy"),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param
	 * --------------------------------------------------
	 */
	static public function getMonthList()
	{
		for($i = 1; $i <= 12; $i++) {

			$result[$i] = implode('', [
				$i,
				//__("lang.date.mm"),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $dd
	 * --------------------------------------------------
	 */
	static public function getDayList($dd = 31)
	{
		for($i = 1; $i <= 31; $i++) {

			$result[$i] = implode('', [
				$i,
				//__("lang.date.dd"),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param date $birthday
	 * --------------------------------------------------
	 */
	static public function getAge($birthday)
	{
		$result = null;

		if(!is_null($birthday)) {

			$date = Carbon::parse($birthday);
			$result = $date->age;
		}

        //echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param date $from
	 * @param date $to
	 * --------------------------------------------------
	 */
	static public function getDateDiff($from, $to)
	{
		$from = strtotime($from);
		$to = strtotime($to);

		// * 差を24（時間）×60（分）×60（秒）で割る
		$result = ($to - $from) / 86400 + 1;

		if($result < 0) {
			$result = 0;
		}

        //echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param
	 * --------------------------------------------------
	 */
	static public function getMeridiem()
    {
        $result = 0;

        $now = Carbon::now()->format('a');
        //echo '<pre>';print_r($now);die();

		if($now == 'pm') $result = 1;

        //echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
     * --------------------------------------------------
	 * @param int $yy
	 * @param int $mm
	 * @param array $response_list
	 * @return	none
     * --------------------------------------------------
	 */
	static public function renderCalendar($yy, $mm, $response_list = [])
	{
		// set result;
		$result = '';

		// set date
		$sdate = Carbon::create($yy, $mm, 1)->toDateString();
		$edate = Carbon::create($yy, ($mm + 1), 0)->toDateString();
		$day = date("j", strtotime($edate));
		$week = date("w", strtotime($sdate));
		$cols = 1;

		for($i = 1; $i <= ($day + $week); $i++) {

			$j = $i - $week;

			if($j < 1) {

				$result .= "<td><div class=\"p-2\">&nbsp;</div></td>\n";
			}
			else {

				$w = date('w', strtotime(Carbon::create($yy, $mm, $i)->toDateString()));
				$today = ($yy == date('Y') && $mm == date('n') && $j == date('j')) ? 'bg-primary bg-opacity-10' : '';
				$color = (isset($response_list[$j])) ? 'primary' : 'secondary';
				$action = action('Backend\Log\SectionController@show', [
					$section_code,
					$yy,
					$mm,
					$j,
				]);

				$result .= "<td class=\"$today\">
					<a href=\"$action\" class=\"text-dark cell\">
						<div class=\"p-2\">
							<h4 class=\"text-$color mb-2 pb-1 border-$color border-bottom border-3\">
								$j
							</h4>
							<ul class=\"list-unstyled mb-0\">
								<li>
									午前：<span class=\"fw-bold\">" . ((isset($response_list[$j])) ? $response_list[$j]['am'] : 0) . "</span>
								</li>
								<li>
									午後：<span class=\"fw-bold\">" . ((isset($response_list[$j])) ? $response_list[$j]['pm'] : 0) . "</span>
								</li>
							</ul>
						</div>
					</a>
				</td>";
			}

			if(($i % 7) == 0) {
				$cols = 0;
				$result .= "</tr>\n";
				if($j != $day) $result .= "<tr class=\"text-center\">\n";
			}
			else {
				if($i == ($day + $week)) {
					for($k = ($cols + 1); $k <= 7; $k++) {
						$result .= "<td><div class=\"p-2\">&nbsp;</div></td>\n";
					}
					$result .= "</tr>\n";
				}
			}

			$cols++;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * text
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param string $string
	 * --------------------------------------------------
	 */
	static public function removeCRLF($string)
	{
		return preg_replace(array("/\r\n/", "/\r/", "/\n/"), '', $string);
	}


	/**
	 * ==================================================
	 * number
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param int $number
     * @param int $total
     * @param int $precision
	 * --------------------------------------------------
	 */
	static public function num2per($number, $total = 100, $precision = 0)
	{
		$result = 0;

		if($number > 0) {

			$result = number_format(($number / $total) * 100, 0);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * file
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param string $file
	 * @param string $directory
	 * --------------------------------------------------
	 */
	static public function uploadFile($file, $directory)
	{
		$base_name = Str::random(32);
		$extension = \File::extension($file->getClientOriginalName());
		$file_name = implode('.', [$base_name, $extension]);

		// saving file
		$file->storeAs(
			$directory,
			$file_name,
			'public'
		);

		return $file_name;
	}

	/**
	 * --------------------------------------------------
	 * @param string $file
	 * --------------------------------------------------
	 */
	static public function removeExtension($file)
	{
		$file_name = pathinfo($file, PATHINFO_FILENAME);

		return $file_name;
	}

	/**
	 * --------------------------------------------------
	 * @param int $size
	 * @param $dec
	 * @param $separate
	 * --------------------------------------------------
	 */
	static public function getByteFormat($size, $dec = -1, $separate = false)
	{
		$units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
		$digits = ($size == 0) ? 0 : floor( log($size, 1024) );

		$over = false;
		$max_digit = count($units) -1 ;

		if($digits == 0){
			$num = $size;
		}

        else if(!isset($units[$digits])) {
			$num = $size / (pow(1024, $max_digit));
			$over = true;
		}

        else {
			$num = $size / (pow(1024, $digits));
		}

		if($dec > -1 && $digits > 0) $num = sprintf("%.{$dec}f", $num);
		if($separate && $digits > 0) $num = number_format($num, $dec);

		return ($over) ? $num . $units[$max_digit] : $num . $units[$digits];
	}


	/**
	 * ==================================================
	 * security
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param int $length
	 * --------------------------------------------------
	 */
	static public function createRandomKey($length = 64)
	{
		$result = Str::random($length);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	static public function createHashKey($keys)
	{
		$result = md5(implode('&', $keys));

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function getHttpQuery($data)
	{
		parse_str(parse_url($data, PHP_URL_QUERY), $result);
		//echo '<pre>';print_r($result);die();

		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function redirectError($patient_code, $error_code)
	{
		return redirect()->action('Frontend\ErrorController@index', [
            $patient_code,
			$error_code,
		]);
	}
}
?>
