<?php

namespace App\Http\Controllers\Backend\Covid\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;

use Illuminate\Http\Request;
use App\Http\Requests\Backend\AcceptedNumberRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class AcceptedNumberController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param  int  mtb_accepted_number_id
	 */
	public function index($mtb_accepted_number_id = null)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'mtb_accepted_number_id' => $mtb_accepted_number_id,
		];
		//echo '<pre>';print_r($data);die();

		if(!is_null($data['mtb_accepted_number_id'])) {

			// get accepted_number
			$data['accepted_number'] = $this->master->getAcceptedNumber(
				$keys = [
					['mtb_accepted_number_id', '=', $data['mtb_accepted_number_id']],
				]
			);
			//echo '<pre>';print_r($data['accepted_number']);die();
		}

		// get accepted_number
		$data['accepted_number'] = $this->master->getAcceptedNumberList(
			$keys = [],
			$orders = [
				'hh' => 'ASC',
				'ii' => 'ASC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['accepted_number']);die();

		// get accepted_number_count
		$data['accepted_number_count'] = count($data['accepted_number']);
		//echo '<pre>';print_r($data['accepted_number_count']);die();

		// set $hour_list
		$data['hour_list'] = Helper::setHourList();
		//echo '<pre>';print_r($data['hour_list']);die();

		// set $minute_list
		$data['minute_list'] = Helper::setMinuteList();
		//echo '<pre>';print_r($data['minute_list']);die();

		// set form
		$data['form'] = [
			'url' => route('admin.covid.master.acceptednumber.store'),
		];

		// set title
		$data['title'] = '';

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.acceptednumber.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(AcceptedNumberRequest $request): RedirectResponse
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function() use($data) {
			//echo '<pre>';print_r($data);die();

			$this->master->storeAcceptedNumber($data);
		});

		// redirect
		return redirect()->route('admin.covid.master.acceptednumber.index');
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
