<?php

namespace App\Http\Controllers\Backend\Covid\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;

use Illuminate\Http\Request;
use App\Http\Requests\Backend\AcceptedNumberRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class DateController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param int $yy
	 * @param int $mm
	 * @return \Illuminate\Http\Response
	 */
	public function index($yy = null, $mm = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
		];
		//echo '<pre>';print_r($data);die();

        // get date_list
        $data['date_list'] = $this->master->getDateIsExistList(
            $keys = [
                ['yy', '=', $data['yy']],
                ['mm', '=', $data['mm']],
            ],
            $orders = [
                'dd' => 'ASC',
            ]
        );
        echo '<pre>';print_r($data['date_list']);die();

		// set title
		$data['title'] = __("lang.master.accepted_number.title");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.acceptednumber.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(AcceptedNumberRequest $request): RedirectResponse
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		//echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function() use($data) {
			//echo '<pre>';print_r($data);die();

			return $this->master->storeAcceptedNumber($data);
		});

		// redirect
		return redirect()->route('admin.covid.master.acceptednumber.index', [
			(!is_null($data['accepted_number']['mtb_accepted_number_id'])) ? $data['accepted_number']['mtb_accepted_number_id'] : '',
		]);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
