<?php

namespace App\Http\Controllers\Backend\Covid\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;

use Illuminate\Http\Request;
use App\Http\Requests\Backend\AcceptedNumberRequest;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class DateController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param int $yy
	 * @param int $mm
	 * @return \Illuminate\Http\Response
	 */
	public function index($yy = null, $mm = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
		];
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
		];
		//echo '<pre>';print_r($data['date']);die();

		// get date_list
		$data['date_list'] = $this->master->getDateIsExistList(
			$keys = [
				['yy', '=', $data['yy']],
				['mm', '=', $data['mm']],
			],
			$orders = [
				'dd' => 'ASC',
			]
		);
		//echo '<pre>';print_r($data['date_list']);die();

		// set title
		$data['title'] = __("lang.master.accepted_number.title");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.date.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request): RedirectResponse
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		echo '<pre>';print_r($data);die();

		/**
		 * --------------------------------------------------
		 * transaction
		 * --------------------------------------------------
		 */
		\DB::transaction(function() use($data) {
			//echo '<pre>';print_r($data);die();

			return $this->master->storeAcceptedNumber($data);
		});

		// redirect
		return redirect()->route('admin.covid.master.acceptednumber.index', [
			(!is_null($data['accepted_number']['mtb_accepted_number_id'])) ? $data['accepted_number']['mtb_accepted_number_id'] : '',
		]);
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * @param int $yy
	 * @param int $mm
	 * @param int $dd
	 * Update the specified resource in storage.
	 */
	public function update($yy, $mm, $dd)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
		];
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
            'mtb_date_id' => $this->master->first(
                'field' => 'mtb_date_id',
                $keys = [
                    ['yy', '=', $data['yy']],
                    ['mm', '=', $data['mm']],
                    ['dd', '=', $data['dd']],
                ]
            ),
		];
		echo '<pre>';print_r($data['date']);die();

		// get date_list
		$data['date_list'] = $this->master->getDateIsExistList(
			$keys = [
				['yy', '=', $data['yy']],
				['mm', '=', $data['mm']],
			],
			$orders = [
				'dd' => 'ASC',
			]
		);
		//echo '<pre>';print_r($data['date_list']);die();

		// get time_list
		$data['time_list'] = $this->master->getTimeList(
			$keys = [
				['mtb_date.yy', '=', $data['yy']],
				['mtb_date.mm', '=', $data['mm']],
				['mtb_date.dd', '=', $data['dd']],
			],
			$orders = [
				'mtb_time.hh' => 'ASC',
				'mtb_time.ii' => 'ASC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['time_list']);die();

        // get accepted_number_list
		$data['accepted_number_list'] = $this->master->getAcceptedNumberList(
			$keys = [],
			$orders = [
				'hh' => 'ASC',
				'ii' => 'ASC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['accepted_number_list']);die();

        // form
        $data['form'] = [
            'url' => route('admin.covid.master.date.store'),
        ];

        // set title
		$data['title'] = __("lang.master.accepted_number.title");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.master.date.update', $data);
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
