<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class HomeController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// initialized
		$data = [];

		// set title
		$data['title'] = '';

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		//echo '<pre>';print_r($data);die();
		return view('backend.home.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
