<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Session,
	Config,
	Carbon\Carbon;

class MocupController extends Controller
{
	public function __construct()
    {
		parent::__construct();
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index()
	{
		//echo '<pre>';print_r(Session::all());die();

		// initialized
		$data = [];

		// get member_list
		$data['member_list'] = $this->member->getMemberList(
			$keys = [
				['dtb_member.dtb_member_id', '!=', Session::get('member.dtb_member_id')],
				['dtb_member.is_auth', '=', 1],
			],
			$orders = [
				'dtb_member.registration_date' => 'DESC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['member_list']);die();

		// get member_list_count
		$data['member_list_count'] = count($data['member_list']);
		//echo '<pre>';print_r($data['member_list_count']);die();

		// set title
		$data['title'] = null;

		//echo '<pre>';print_r($data);die();
		return view('frontend.member.index', $data);
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  string  $member_code
	 * @return \Illuminate\Http\Response
	 */
	public function show($member_code)
	{
		// initialized
		$data = [];

		// get parameters
		$data = [
			'member_code' => $member_code,
		];
		//echo '<pre>';print_r($data);die();

		// get member
		$data['member'] = $this->member->getMember(
			$keys = [
				['member_code', '=', $data['member_code']],
			]
		);
		//echo '<pre>';print_r($data['member']);die();

		// get area_list
		$data['area_list'] = $this->member->getAreaDropdownList(
			$keys = [
				['dtb_area.dtb_member_id', '=', $data['member']['dtb_member_id']],
			],
			$orders = [
				'mtb_area.seq' => 'ASC',
			],
			$options = []
		);
		//echo '<pre>';print_r($data['area_list']);die();

		// set table_list
		$table_list = [
			'skill',
			'request',
			'job',
			'certification',
			'goodat',
			'hobby',
		];

		// get profile
		$data['profile'] = [];

		foreach($table_list as $table) {
			//echo '<pre>';print_r($table);die();

			$data['profile'][$table] = $this->member->getProfileDropdownList(
				[
					'dtb_member_id' => $data['member']['dtb_member_id'],
				],
				$table
			);
		}
		//echo '<pre>';print_r($data['profile']);die();

		// set title
		$data['title'] = null;

		//echo '<pre>';print_r($data);die();
		return view('frontend.member.show', $data);
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function update(Request $request, $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy($id)
	{
		//
	}
}
