<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AuthRequest extends FormRequest
{
	protected $table = 'dtb_member';

	/**
	 * Determine if the user is authorized to make this request.
	 *
	 * @return bool
	 */
	public function authorize()
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array
	 */
	public function rules()
	{
		$rules = [
			'member.email' => "required|email|unique:{$this->table},email",
		];

	   return $rules;
	}

	/**
	 *
	 * @return array
	 */
	public function messages()
	{
		$message = 'は入力必須項目です';

		return [
			'member.email.required' => implode('', [__("locale.member.email"), $message]),
			'member.email.email' => 'Eメールを正しく入力してください',
			'member.email.unique' => 'このEメールはすでに登録されています',
		];
	}
}
