<?php

namespace App\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;

class AcceptedNumberRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'accepted_number.hh' => 'required',
			'accepted_number.ii' => 'required',
			'accepted_number.accepted_number' => 'required',
		];
	}

	// /**
	//  * Get custom attributes for validator errors.
	//  *
	//  * @return array<string, string>
	//  */
	// public function attributes(): array
	// {
	// 	return [
	// 		'accepted_number.hh' => __("lang.master.accepted_number.hh"),
	// 		'accepted_number.ii' => __("lang.master.accepted_number.ii"),
	// 		'accepted_number.accepted_number' => __("lang.master.accepted_number.accepted_number"),
	// 	];
	// }

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
		return [
			'accepted_number.hh.required' => 'A title is required',
			'accepted_number.ii.required' => 'A message is required',
			'accepted_number.accepted_number' => 'A message is required',
		];
	}
}
