<?php

namespace App\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;

class AcceptedNumberRequest extends FormRequest
{
	/**
	 * Determine if the user is authorized to make this request.
	 */
	public function authorize(): bool
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
	 */
	public function rules(): array
	{
		return [
			'accepted_number.hh' => 'required',
			'accepted_number.ii' => 'required',
			'accepted_number.accepted_number' => 'required',
		];
	}

	/**
	 * Get the error messages for the defined validation rules.
	 *
	 * @return array<string, string>
	 */
	public function messages(): array
	{
        echo \App::currentLocale();die();
		return [
			'accepted_number.hh.required' => __("lang.accepted_number.hh"),
			'accepted_number.ii.required' => __("lang.accepted_number.ii"),
			'accepted_number.accepted_number' => __("lang.accepted_number.accepted_number"),
		];
	}
}
