<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppRepositoryProvider extends ServiceProvider
{
	/**
	 * Register the application services.
	 *
	 * @return void
	 */
	public function register()
	{
		foreach([

			// Statement
			[
				\App\Repositories\StatementInterface::class,
				\App\Repositories\Statement::class,
			],

			// View
			[
				\App\Repositories\ViewInterface::class,
				\App\Repositories\View::class,
			],
		] as $register) {

			$this->app->singleton(
				$register[0],
				$register[1]
			);
		}
	}

    /**
	 * Bootstrap the application services.
	 *
	 * @return void
	 */
	public function boot()
	{
		//
	}
}
