<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        foreach([

            // Service
			[
				\App\Services\ServiceInterface::class,
				\App\Services\Service::class
			],

			// Master
			[
				\App\Services\MasterInterface::class,
				\App\Services\Master::class
			],
        ] as $register) {

			$this->app->singleton(
				$register[0],
				$register[1]
			);
		}
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
