<?php

namespace App\Repositories;

interface ViewInterface
{
	/**
	 * ==================================================
	 * common
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $key
	 * @param unknown $value
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getLabelList($key, $value, $table);


	/**
	 * ==================================================
	 * user
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUser($keys);

	/**
	 *
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array $result
	 * --------------------------------------------------
	 */
	public function getUserCount($keys);

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserLogList($keys = [], $orders = [], $options = []);


	/*
	 |==================================================
	 | log_api
	 |==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getLogApiList($keys, $orders, $options);

    /**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getLogList($keys, $orders, $options);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getLogCount($keys);

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserLogCountList($keys);

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserLogCount($keys);


    /*
	 |==================================================
	 | sub_category
	 |==================================================
	 */

    /**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getSubCategoryGroupbyList($keys, $orders, $options);
}
