<?php

namespace App\Repositories;

use stdCgetCourseListlass,
	Exception,
	PDOException,
	Carbon\Carbon;

// use interface
use App\Repositories\ViewInterface;

class View implements ViewInterface
{
	public function __construct()
	{
		//
	}


	/**
	 * ==================================================
	 * common
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $key
	 * @param unknown $value
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getLabelList($key, $value, $table)
	{
		try {
			$result = \DB::table(\DB::raw("(SELECT * FROM $this->mtb_language WHERE is_disabled = 0) AS $this->mtb_language"))

				// columns
				->select(
					"$table.*",
					"$this->mtb_language.mtb_language_id",
					"$this->mtb_language.language_code",
					"$this->mtb_language.language_label"
				)

				// left join to table
				->leftJoinSub((\DB::table($table)->where($key, $value)), $table, function($join) use ($table) {
					$join->on("$this->mtb_language.mtb_language_id", '=', "$table.mtb_language_id");
				})
				->get();

			// echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}


	/**
	 * ==================================================
	 * user
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * @param $options
	 * --------------------------------------------------
	 */
	public function getUserList($keys = [], $orders = [], $options = [])
	{
		try {

			$result = [];

			$return = \DB::table('dtb_user')

				->select(

					// dtb_user
					'dtb_user.*',

					// dtb_company
					'dtb_company.company_code',
					'dtb_company.company_name',
					'dtb_company.is_agency',

					// dtb_branch
					'dtb_branch.branch_code',
					'dtb_branch.branch_name',

					// log_count
					// \DB::raw("(
					// 	SELECT
					// 		COUNT(*)
					// 	FROM
					// 		`dtb_log` AS `T1`
					// 	WHERE
					// 		`T1`.`dtb_user_id` = `dtb_user`.`dtb_user_id` AND
					// 		`T1`.`yy` = " . date('Y') . " AND
					// 		`T1`.`mm` = " . date('n') . "
					// ) AS `log_count`"),
				)

				// join to dtb_company
				->leftJoin('dtb_company', 'dtb_user.dtb_company_id', '=', 'dtb_company.dtb_company_id')

				// join to dtb_branch
				->leftJoin('dtb_branch', 'dtb_user.dtb_branch_id', '=', 'dtb_branch.dtb_branch_id');

			// set keys
			if($keys) {

				$return = $return->where($keys);
			}

			// set orders
			if($orders) {

				foreach($orders as $key => $value) {

					$return = $return->orderBy($key, $value);
				}
			}

			// get result
			$return = $return->get();
			$return = json_decode(json_encode($return), true);
			//echo '<pre>';print_r($return);die();

			foreach($return as $key => $value) {

				$result[$value['dtb_user_id']] = $value;
			}
			//echo '<pre>';print_r($result);die();

			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getUser($keys)
	{
		try {
			$result = \DB::table('dtb_user')

				// columns
				->select(

					// dtb_user
					'dtb_user.*',

					// dtb_branch
					'dtb_branch.branch_code',
					'dtb_branch.branch_name',

					// dtb_company
					'dtb_company.company_code',
					'dtb_company.company_name',
					'dtb_company.is_agency',
					'dtb_company.is_expired',
				)

				// join to dtb_branch
				->leftJoin('dtb_branch', 'dtb_user.dtb_branch_id', '=', 'dtb_branch.dtb_branch_id')

				// join to dtb_company
				->leftJoin('dtb_company', 'dtb_user.dtb_company_id', '=', 'dtb_company.dtb_company_id');

			// set keys
			$result = $result->where($keys);

			// get result
			$result = $result->first();

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 *
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array $result
	 * --------------------------------------------------
	 */
	public function getUserCount($keys)
	{
		try {
			$result = \DB::table('dtb_user')
				->select(

					// dtb_user
					'dtb_user.dtb_user_id',
				)

				// join to dtb_company
				->leftJoin('dtb_company', 'dtb_user.dtb_company_id', '=', 'dtb_company.dtb_company_id');

			// set keys
			if($keys) {

				$result = $result->where($keys);
			}

			// get result
			$result = $result->count();

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserLogList($keys = [], $orders = [], $options = [])
	{
		try {

			$sql = "
				SELECT
					`dtb_user`.`dtb_user_id`,
					`dtb_user`.`user_number`,
					`dtb_user`.`user_code`,
					`dtb_user`.`user_id`,
					`dtb_user`.`division_name`,
					`dtb_user`.`user_name`,
					`dtb_company`.`serial_number`,
					`dtb_company`.`company_code`,
					`dtb_company`.`company_name`,
					(
						SELECT
							COUNT(*)
						FROM
							`dtb_part_log` AS `T1`
						WHERE
							`T1`.`yy` = ? AND
							`T1`.`mm` = ? AND
							`T1`.`dtb_user_id` = `dtb_user`.`dtb_user_id`
					) AS `log_count`
				FROM
					`dtb_user`
				LEFT JOIN `dtb_company` ON
					`dtb_user`.`dtb_company_id` = `dtb_company`.`dtb_company_id`
				WHERE
					`dtb_user`.`dtb_company_id` = ?
				ORDER BY
					`dtb_user`.`date_created` ASC
			";

			$params = [
				$keys['yy'],
				$keys['mm'],
				$keys['dtb_company_id'],
			];

			$result = \DB::select($sql, $params);

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}


	/*
	 | ==================================================
	 | log_api
	 | ==================================================
	 |
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getLogApiList($keys, $orders, $options)
	{
		try {

			$result = \DB::table('dtb_log_api')

				// columns
				->select(

					// dtb_log_api
					'dtb_log_api.*',

					// dtb_user
					'dtb_user.account',
				)

				// join to dtb_user
				->leftJoin('dtb_user', 'dtb_user.dtb_user_id', '=', 'dtb_log_api.dtb_user_id');

			// set keys
			if($keys) {

				$result = $result->where($keys);
			}

			// set orders
			if($orders) {

				foreach($orders as $key => $value) {
					$result = $result->orderBy($key, $value);
				}
			}

			$result = $result->get();

			//echo '<pre>';print_r($result);die();
			return json_decode(json_encode($result), true);
		}
		catch(PDOException $e) {
			throw $e;
		}
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getLogList($keys, $orders, $options)
	{
		$result = \DB::table('dtb_log')

			// columns
			->select(

				// dtb_log
				'dtb_log.*',

				// dtb_user
				'dtb_user.user_sname',
				'dtb_user.user_gname',
			)

			// join to dtb_user
			->leftJoin('dtb_user', 'dtb_log.dtb_user_id', '=', 'dtb_user.dtb_user_id');

		// set keys
		if($keys) {
			$result = $result->where($keys);
		}

		// set orders
		if($orders) {
			foreach($orders as $key => $value) {
				$result = $result->orderBy($key, $value);
			}
		}

		// get result
		$result = $result->get();

		$result = json_decode(json_encode($result), true);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getLogCount($keys)
	{
		$result = \DB::table("$this->dtb_log");

		// set keys
		if($keys) {
			$result = $result->where($keys);
		}

		// get result
		$result = $result->count();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserLogCountList($keys)
	{
		//echo '<pre>';print_r($keys);die();

		// initialized
		$result = [];

		// $sql = "
		// 	SELECT
		// 		dtb_user.dtb_user_id,
		// 		dtb_user.user_code,
		// 		dtb_user.is_adjuster,
		// 		dtb_user.is_limited,
		// 		(SELECT COUNT('dtb_log_id') FROM dtb_log AS T1 WHERE T1.dtb_user_id = dtb_user.dtb_user_id AND T1.yy = ? AND T1.mm = ? AND T1.is_vin = 1 AND T1.listPrice IS NOT NULL) AS vin,
		// 		(SELECT COUNT('dtb_log_id') FROM dtb_log AS T2 WHERE T2.dtb_user_id = dtb_user.dtb_user_id AND T2.yy = ? AND T2.mm = ? AND T2.is_vin = 0 AND T2.listPrice IS NOT NULL) AS oem,
		// 		(SELECT COUNT('dtb_log_id') FROM dtb_log AS T3 WHERE T3.dtb_user_id = dtb_user.dtb_user_id AND T3.yy = ? AND T3.mm = ? AND T3.listPrice IS NOT NULL) AS total
		// 	FROM
		// 		dtb_user
		// 	WHERE
		// 		dtb_user.is_auth = 1 AND
		// 		dtb_user.dtb_branch_id = ? AND
		// 		dtb_user.dtb_company_id = ?";

		$sql = "
			SELECT
				dtb_user.dtb_user_id,
				dtb_user.user_code,
				dtb_user.is_adjuster,
				dtb_user.is_limited,
				(SELECT COUNT('dtb_log_id') FROM dtb_log AS T1 WHERE T1.dtb_user_id = dtb_user.dtb_user_id AND T1.yy = ? AND T1.mm = ? AND T1.is_vin = 1 AND T1.is_notfound = 0) AS vin,
				(SELECT COUNT('dtb_log_id') FROM dtb_log AS T2 WHERE T2.dtb_user_id = dtb_user.dtb_user_id AND T2.yy = ? AND T2.mm = ? AND T2.is_vin = 0 AND T2.is_notfound = 0) AS oem,
				(SELECT COUNT('dtb_log_id') FROM dtb_log AS T3 WHERE T3.dtb_user_id = dtb_user.dtb_user_id AND T3.yy = ? AND T3.mm = ? AND T3.is_notfound = 0) AS total
			FROM
				dtb_user
			WHERE
				dtb_user.is_auth = 1 AND
				dtb_user.dtb_branch_id = ? AND
				dtb_user.dtb_company_id = ?";

		$params = [
			$keys['yy'],
			$keys['mm'],
			$keys['yy'],
			$keys['mm'],
			$keys['yy'],
			$keys['mm'],
			$keys['dtb_branch_id'],
			$keys['dtb_company_id'],
		];

		$return = \DB::select(
			$sql,
			$params
		);

		$return = json_decode(json_encode($return), true);
		//echo '<pre>';print_r($return);die();

		foreach($return as $key => $value) {
			//echo '<pre>';print_r($value);die();

			$result[$value['dtb_user_id']] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getUserLogCount($keys)
	{
		//echo '<pre>';print_r($keys);die();

		// initialized
		$result = [];

		$sql = "
			SELECT
				dtb_user.dtb_user_id,
				(SELECT COUNT('dtb_log_id') FROM dtb_log AS T1 WHERE T1.dtb_user_id = dtb_user.dtb_user_id AND T1.yy = ? AND T1.mm = ? AND T1.is_vin = 1) AS vin,
				(SELECT COUNT('dtb_log_id') FROM dtb_log AS T2 WHERE T2.dtb_user_id = dtb_user.dtb_user_id AND T2.yy = ? AND T2.mm = ? AND T2.is_vin = 0) AS oem,
				(SELECT COUNT('dtb_log_id') FROM dtb_log AS T3 WHERE T3.dtb_user_id = dtb_user.dtb_user_id AND T3.yy = ? AND T3.mm = ?) AS total
			FROM
				dtb_user
			WHERE
				dtb_user.is_auth = 1 AND
				dtb_user.dtb_user_id = ?";

		$params = [
			$keys['yy'],
			$keys['mm'],
			$keys['yy'],
			$keys['mm'],
			$keys['yy'],
			$keys['mm'],
			$keys['dtb_user_id'],
		];
		//echo '<pre>';print_r($params);die();

		$result = \DB::selectOne(
			$sql,
			$params
		);

		$result = json_decode(json_encode($result), true);

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/*
	 |==================================================
	 | sub_category
	 |==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $options
	 * @return unknown
	 * --------------------------------------------------
	 */
	public function getSubCategoryGroupbyList($keys, $orders, $options)
	{
		try {

			$result = \DB::table('mtb_sub_category')

				// columns
				->select(

					// mtb_sub_category
					'mtb_sub_category.sub_category_code',
					'mtb_sub_category.sub_category_name',
					'mtb_sub_category.mtb_main_category_id',

					\DB::raw("(SELECT sp_code FROM `mtb_sub_category` AS `T1` WHERE `T1`.`sub_category_code` = `mtb_sub_category`.`sub_category_code` LIMIT 1) as `sp_code`")
				);

			// set keys
			if($keys) {

				$result = $result->where($keys);
			}

			// set orders
			if($orders) {

				foreach($orders as $key => $value) {
					$result = $result->orderBy($key, $value);
				}
			}

			// set groupby
			$result = $result->groupBy(
				'mtb_sub_category.sub_category_code',
				'mtb_sub_category.sub_category_name',
				'mtb_sub_category.mtb_main_category_id'
			);

			// get result
			$result = $result->get();

			$result = json_decode(json_encode($result), true);

			//echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}
}
