<?php

namespace App\Repositories;

use stdCgetCourseListlass,
	Exception,
	PDOException,
	Carbon\Carbon;

// use interface
use App\Repositories\ViewInterface;

class View implements ViewInterface
{
	public function __construct()
	{
		//
	}


	/**
	 * ==================================================
	 * common
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param unknown $key
	 * @param unknown $value
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getLabelList($key, $value, $table)
	{
		try {
			$result = \DB::table(\DB::raw("(SELECT * FROM $this->mtb_language WHERE is_disabled = 0) AS $this->mtb_language"))

				// columns
				->select(
					"$table.*",
					"$this->mtb_language.mtb_language_id",
					"$this->mtb_language.language_code",
					"$this->mtb_language.language_label"
				)

				// left join to table
				->leftJoinSub((\DB::table($table)->where($key, $value)), $table, function($join) use ($table) {
					$join->on("$this->mtb_language.mtb_language_id", '=', "$table.mtb_language_id");
				})
				->get();

			// echo '<pre>';print_r($result);die();
			return $result;
		}
		catch(PDOException $e) {
			throw $e;
		}
	}


    /**
	 * ==================================================
	 * time
	 * ==================================================
	 */

    /**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getTimeList($keys, $orders, $options)
    {
        try {
            $result = \DB::table('mtb_time')
                // mtb_time
                ->select(

                    // mtb_time
                    'mtb_time.*',

                    // dtb_date
                    'dtb_date.yy',
                    'dtb_date.mm',
                    'dtb_date.dd',
                    'dtb_date.accepted_numbers',
                )

                // join to dtb_user
			->leftJoin('dtb_user', 'dtb_log.dtb_user_id', '=', 'dtb_user.dtb_user_id');

            // set keys
            if($keys) {
                $result = $result->where($keys);
            }

            // set orders
            if($orders) {
                foreach($orders as $key => $value) {
                    $result = $result->orderBy($key, $value);
                }
            }

            // get result
            $result = $result->get();

            $result = json_decode(json_encode($result), true);

            //echo '<pre>';print_r($result);die();
            return $result;
        }
		catch(PDOException $e) {
			throw $e;
		}
    }
}
