<?php
namespace App\Services;

interface MasterInterface
{
	/**
	 * ==================================================
	 * master
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterList($keys = [], $orders = [], $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterDropdownList($keys = [], $orders = [], $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaster($keys, $table);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMaster($data);


	/**
	 * ==================================================
	 * language
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageDropDownList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getLanguage($keys);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getLanguageId($language_code);


	/**
	 * ==================================================
	 * brand
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getBrandList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getBrandDropdownList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getBrand($keys);


	/**
	 * ==================================================
	 * main_category
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMainCategoryList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMainCategoryDropdownList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMainCategory($keys);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMainCategory($data);


	/**
	 * ==================================================
	 * sub_category
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryDropdownList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryGroupbyList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryCodeList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategory($keys);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeSubCategory($data);


	/**
	 * ==================================================
	 * maker
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMakerList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMakerDropdownList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaker($keys);


	/**
	 * ==================================================
	 * pref
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getPrefList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getPrefDropdownList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getPref($keys);


	/**
	 * ==================================================
	 * vin
	 * ==================================================
	 */

	/**
	 * @param $keys
	 * @param $orders
	 */
	public function getDateLengthDropDownList($keys, $orders);
}
