<?php
namespace App\Services;

interface MasterInterface
{
	/**
	 * ==================================================
	 * master
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterList($keys = [], $orders = [], $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterDropdownList($keys = [], $orders = [], $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaster($keys, $table);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMaster($data);


	/**
	 * ==================================================
	 * language
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageDropDownList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getLanguage($keys);

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getLanguageId($language_code);


	/**
	 * ==================================================
	 * accepted_number
	 * ==================================================
	 */

    /**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getAcceptedNumberList($keys = [], $orders = []);

    /**
	 * --------------------------------------------------
	 * @param $keys
	 * --------------------------------------------------
	 */
	public function getAcceptedNumber($keys);
}
