<?php
namespace App\Services;

interface MasterInterface
{
	/**
	 * ==================================================
	 * master
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterList($keys = [], $orders = [], $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterDropdownList($keys = [], $orders = [], $table);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaster($keys, $table);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMaster($data);


	/**
	 * ==================================================
	 * language
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getLanguageList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getLanguageDropDownList($keys = [], $orders = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getLanguage($keys);

	/**
	 * --------------------------------------------------
	 * @param string $language_code
	 * --------------------------------------------------
	 */
	public function getLanguageId($language_code);


	/**
	 * ==================================================
	 * accepted_number
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getAcceptedNumberList($keys = [], $orders = [], $options = []);

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getAcceptedNumber($keys);

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeAcceptedNumber($data);
}
