<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

// use components
use Session,
	Carbon\Carbon,
	Carbon\CarbonPeriod,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Master extends Service implements MasterInterface
{
	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}


	/**
	 * ==================================================
	 * master
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterList($keys = [], $orders = [], $table)
	{
		//echo '<pre>';print_r($table);die();

		$result = $this->statement->get(
			$keys,
			$orders,
			"mtb_{$table}"
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterDropdownList($keys = [], $orders = [], $table)
	{
		//echo '<pre>';print_r($keys);die();

		// initialized
		$result = [];

		$return = $this->getMasterList($keys, $orders, $table);
		//echo '<pre>';print_r($return);die();

		foreach($return as $key => $value) {
			//echo '<pre>';print_r($value);die();

			$result[$value["mtb_{$table}_id"]] = $value["{$table}_name"];
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaster($keys, $table)
	{
		$result = $this->statement->first(
			$keys,
			"mtb_{$table}"
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMaster($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		$values = [
			"{$data['table']}_name" => $data['master']["{$data['table']}_name"],
			'seq' => $data['master']['seq'],
			'remark' => $data['master']['remark'],
			'is_disabled' => $data['master']['is_disabled'],
		];
		//echo '<pre>';print_r($values);die();

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['master']["mtb_{$data['table']}_id"])) {

			$this->statement->insert(
				$values,
				$table = "mtb_{$data['table']}");
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {

			$this->statement->update(
				$keys = [
					["mtb_{$data['table']}_id", '=', $data['master']["mtb_{$data['table']}_id"]],
				],
				$values,
				$table = "mtb_{$data['table']}");
		}
	}


	/**
	 * ==================================================
	 * language
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageList($keys = [], $orders = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_language'
		);

		//print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageDropDownList($keys = [], $orders = [])
	{
		$result = [];

		$return = $this->getLanguageList(
			$keys,
			$orders
		);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['language_code']] = $value['language_label'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguage($keys = [])
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_language'
		);

		//print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param $keys
	 * @param $orders
	 * --------------------------------------------------
	 */
	public function getLanguageId($language_code)
	{
		$mtb_language_id = $this->statement->field(
			$field = 'mtb_language_id',
			$keys = [
				['language_code', '=', $language_code],
			],
			$table = 'mtb_language'
		);
		//print_r($result);die();

        Session::put('lang_id', $mtb_language_id);
	}


	/**
	 * ==================================================
	 * brand
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getBrandList($keys = [], $orders = [], $options = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_brand'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getBrandDropdownList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->getBrandList($keys, $orders, $options);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['brand_id']] = $value['brand_name'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getBrand($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_brand'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * main_category
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMainCategoryList($keys = [], $orders = [], $options = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_main_category'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMainCategoryDropdownList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->getMainCategoryList($keys, $orders, $options);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['mtb_main_category_id']] = $value['main_category_name'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMainCategory($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_main_category'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMainCategory($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		// set column_list
		$column_list = [
			'main_category_code',
			'main_category_name',
			'seq',
			'is_disabled',
		];

		foreach($column_list as $column) {

			if(isset($data['main_category'][$column])) {

				$values[$column] = $data['main_category'][$column];
			}
		}
		//echo '<pre>';print_r($values);die();

		$values['main_category_code'] = sprintf('%03d', $values['main_category_code']);

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['main_category']['main_category_key'])) {

			// set dtb_company_id
			$values = array_merge($values, [
				'main_category_key' => Helper::createRandomKey(24),
			]);
			//echo '<pre>';print_r($values);die();

			$this->statement->insert(
				$values,
				$table = 'mtb_main_category'
			);

			return $values;
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {

			$this->statement->update(
				$keys = [
					['main_category_key', '=', $data['main_category']['main_category_key']],
				],
				$values,
				$table = 'mtb_main_category'
			);

			//echo '<pre>';print_r($data);die();
			return $data;
		}
	}

	/**
	 * ==================================================
	 * sub_category
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryList($keys = [], $orders = [], $options = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_sub_category'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryDropdownList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->getSubCategoryList($keys, $orders, $options);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['mtb_sub_category_id']] = $value['sub_category_name'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryGroupbyList($keys = [], $orders = [], $options = [])
	{
		$result = $this->view->getSubCategoryGroupbyList(
			$keys,
			$orders,
			$options
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategoryCodeList($keys = [], $orders = [], $options = [])
	{
		$result = [
			'parHinmokuNos' => [],
			'parMakerNos' => [],
		];

		$return = $this->getSubCategoryList($keys, $orders, $options);
		//echo '<pre>';print_r($return);die();

		foreach($return as $key => $value) {
			//echo '<pre>';print_r($value);die();

			$result['parHinmokuNos'][] = $value['sp_code'];
			$result['parMakerNos'][] = '0001';
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getSubCategory($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_sub_category'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeSubCategory($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		// set column_list
		$column_list = [
			'sub_category_code',
			'sub_category_name',
			'seq',
			'is_disabled',
			'mtb_main_category_id',
		];

		foreach($column_list as $column) {

			if(isset($data['sub_category'][$column])) {

				$values[$column] = $data['sub_category'][$column];
			}
		}
		//echo '<pre>';print_r($values);die();

		$values['sub_category_code'] = sprintf('%05d', $values['sub_category_code']);
		//echo '<pre>';print_r($values);die();

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['sub_category']['sub_category_key'])) {

			// set sub_category_key
			$values = array_merge($values, [
				'sub_category_key' => Helper::createRandomKey(24),
			]);
			//echo '<pre>';print_r($values);die();

			$this->statement->insert(
				$values,
				$table = 'mtb_sub_category'
			);

			return $values;
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {

			$this->statement->update(
				$keys = [
					['sub_category_key', '=', $data['sub_category']['sub_category_key']],
				],
				$values,
				$table = 'mtb_sub_category'
			);

			//echo '<pre>';print_r($data);die();
			return $data;
		}
	}

	/**
	 * ==================================================
	 * maker
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMakerList($keys = [], $orders = [], $options = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_maker'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMakerDropdownList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->getMakerList($keys, $orders, $options);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['maker_code']] = $value['maker_name'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaker($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_maker'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * pref
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getPrefList($keys = [], $orders = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_pref');

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getPrefDropdownList($keys = [], $orders = [])
	{
		$result = [];

		$return = $this->getPrefList($keys, $orders);
		//echo '<pre>';print_r($return);die();

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['mtb_pref_id']] = $value['pref_name'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @return array
	 * --------------------------------------------------
	 */
	public function getPref($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_pref');

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * vin
	 * ==================================================
	 */

	/**
	 * @param $keys
	 * @param $orders
	 */
	public function getDateLengthDropDownList($keys, $orders)
	{
		$result = [];

		$return = $this->getBrandList($keys, $orders);
		//echo '<pre>';print_r($return);die();

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['brand_id']] = $value['date_length'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}
}
