<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Exception;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Master extends Service implements MasterInterface
{
	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}


	/**
	 * ==================================================
	 * master
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterList($keys = [], $orders = [], $table)
	{
		//echo '<pre>';print_r($table);die();

		$result = $this->statement->get(
			$keys,
			$orders,
			"mtb_{$table}"
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMasterDropdownList($keys = [], $orders = [], $table)
	{
		//echo '<pre>';print_r($keys);die();

		// initialized
		$result = [];

		$return = $this->getMasterList($keys, $orders, $table);
		//echo '<pre>';print_r($return);die();

		foreach($return as $key => $value) {
			//echo '<pre>';print_r($value);die();

			$result[$value["mtb_{$table}_id"]] = $value["{$table}_name"];
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * @return array
	 * --------------------------------------------------
	 */
	public function getMaster($keys, $table)
	{
		$result = $this->statement->first(
			$keys,
			"mtb_{$table}"
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeMaster($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$values = [];

		$values = [
			"{$data['table']}_name" => $data['master']["{$data['table']}_name"],
			'seq' => $data['master']['seq'],
			'remark' => $data['master']['remark'],
			'is_disabled' => $data['master']['is_disabled'],
		];
		//echo '<pre>';print_r($values);die();

		/**
		 * --------------------------------------------------
		 * insert
		 * --------------------------------------------------
		 */
		if(is_null($data['master']["mtb_{$data['table']}_id"])) {

			$this->statement->insert(
				$values,
				$table = "mtb_{$data['table']}");
		}

		/**
		 * --------------------------------------------------
		 * update
		 * --------------------------------------------------
		 */
		else {

			$this->statement->update(
				$keys = [
					["mtb_{$data['table']}_id", '=', $data['master']["mtb_{$data['table']}_id"]],
				],
				$values,
				$table = "mtb_{$data['table']}");
		}
	}


	/**
	 * ==================================================
	 * language
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getLanguageList($keys = [], $orders = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_language'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getLanguageDropDownList($keys = [], $orders = [])
	{
		$result = [];

		$return = $this->getLanguageList(
			$keys,
			$orders
		);

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['language_code']] = $value['language_label'];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getLanguage($keys = [])
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_language'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param string $language_code
	 * --------------------------------------------------
	 */
	public function getLanguageId($language_code)
	{
		$mtb_language_id = $this->statement->field(
			$field = 'mtb_language_id',
			$keys = [
				['language_code', '=', $language_code],
			],
			$table = 'mtb_language'
		);
		//print_r($result);die();

		Session::put('lang_id', $mtb_language_id);
	}


	/**
	 * ==================================================
	 * accepted_number
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getAcceptedNumberList($keys = [], $orders = [], $options = [])
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_accepted_number'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getAcceptedNumber($keys)
	{
		$result = $this->statement->first(
			$keys,
			$table = 'mtb_accepted_number'
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeAcceptedNumber($data)
	{
		//echo '<pre>';print_r($data);die();

		$values = [];

		$column_list = [
			'hh',
			'ii',
			'accepted_number',
		];

		foreach($column_list as $column) {

			if(isset($data['accepted_number'][$column])) {

				$values[$column] = $data['accepted_number'][$column];
			}
		}
		//echo '<pre>';print_r($values);die();

		// insert
		if(!isset($data['accepted_number']['mtb_accepted_number_id'])) {
			//die('insert');

			$data['accepted_number']['mtb_accepted_number_id'] = $this->statement->insert(
				$values,
				$table = 'mtb_accepted_number'
			);
		}

		// update
		else {
			//die('update');

			$this->statement->update(
				$keys = [
					['mtb_accepted_number_id', '=', $data['accepted_number']['mtb_accepted_number_id']],
				],
				$values,
				$table = 'mtb_accepted_number'
			);
		}

		//echo '<pre>';print_r($data);die();
		return $data;
	}


	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getDateList($keys = [], $orders = [], $options = [])
	{

	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * --------------------------------------------------
	 */
	public function getDateIsExistList($keys = [], $orders = [])
	{
		// initialized
		$result = [];

		$return = $this->statement->get(
			$keys,
			$orders,
			$table = 'mtb_date'
		);
		//echo '<pre>';print_r($return);die();

		if($return) {

			foreach($return as $key => $value) {

				$result[$value['dd']] = [
					'date' => $value['date'],
					'yy' => $value['yy'],
					'mm' => $value['mm'],
					'accepted_numbers' => $value['accepted_numbers'],
				];
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getDate($keys)
	{
        $result = $this->statement->get(
			$keys,
			$table = 'mtb_date'
		);

        //echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeDate($data)
	{
        //echo '<pre>';print_r($data);die();

		$values = [];

		$column_list = [
			'hh',
			'ii',
			'dd',
		];

		foreach($column_list as $column) {

			if(isset($data['accepted_number'][$column])) {

				$values[$column] = $data['accepted_number'][$column];
			}
		}
		//echo '<pre>';print_r($values);die();
	}


	/**
	 * ==================================================
	 * time
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param array $options
	 * --------------------------------------------------
	 */
	public function getTimeList($keys = [], $orders = [], $options = [])
	{
		$result = [];

		$return = $this->view->getTimeList(
			$keys,
			$orders,
			$options
		);

		foreach($return as $key => $value) {

			$result[$value['hh']][$value['ii']] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	public function getTime($keys)
	{

	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	public function storeTime($data)
	{

	}
}
