<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;

// using components
use Session,
	Carbon\Carbon,
	Carbon\CarbonPeriod,
	App\Helper;

// using interfaces
use App\Repositories\StatementInterface,
	App\Repositories\ViewInterface;

class Service implements ServiceInterface
{
	protected
		$statement,
		$view;

	public function __construct(
		StatementInterface $statement,
		ViewInterface $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $orders
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getList($keys, $orders, $table)
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getFirst($keys, $table)
	{
		$result = $this->statement->first(
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $field
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getField($field, $keys, $table)
	{
		// get result
		$result = $this->statement->field(
			$field,
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $field
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getMax($field, $keys, $table)
	{
		// get result
		$result = $this->statement->max(
			$field,
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function getCount($keys, $table)
	{
		// get result
		$result = $this->statement->count(
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function insertRow($values, $table)
	{
		// get result
		$result = $this->statement->insert(
			$values,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param unknown $keys
	 * @param unknown $table
	 * --------------------------------------------------
	 */
	public function deleteRow($keys, $table)
	{
		// get result
		$result = $this->statement->delete(
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}
}
