<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class Service implements ServiceInterface
{
	protected
		$statement,
		$view;

	public function __construct(
		Statement $statement,
		View $view
	) {
		$this->statement = $statement;
		$this->view = $view;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $orders
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function getList($keys, $orders, $table)
	{
		$result = $this->statement->get(
			$keys,
			$orders,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function getFirst($keys, $table)
	{
		$result = $this->statement->first(
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $field
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function getField($field, $keys, $table)
	{
		// get result
		$result = $this->statement->field(
			$field,
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $field
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function getMax($field, $keys, $table)
	{
		// get result
		$result = $this->statement->max(
			$field,
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function getCount($keys, $table)
	{
		// get result
		$result = $this->statement->count(
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function insertRow($values, $table)
	{
		// get result
		$result = $this->statement->insert(
			$values,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param array $values
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function updateRow($keys, $values, $table)
	{
		// get result
		$result = $this->statement->update(
			$keys,
			$values,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * @param string $table
	 * --------------------------------------------------
	 */
	public function deleteRow($keys, $table)
	{
		// get result
		$result = $this->statement->delete(
			$keys,
			$table
		);

		//echo '<pre>';print_r($result);die();
		return json_decode(json_encode($result), true);
	}
}
