@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		{!! Form::open($form) !!}
		{!! Form::hidden('', '', $mtb_accepted_number_id) !!}

		<div class="card mb-3">
			<div class="card-body">

				<div class="mb-3">
					<label
						class=""
						for=""
					>
						{!! __("lang.master.accepted_number.time") !!}
					</label>
					<div class="input-group">
						{!! Form::select('', ['' => ''] + $hour_list, '', [
							'class' => 'form-select',
						]) !!}
						<span class="input-group-text">
							{!! __("lang.date.hh") !!}
						</span>
						{!! Form::select('', ['' => ''] + $minute_list, '', [
							'class' => 'form-select',
						]) !!}
						<span class="input-group-text">
							{!! __("lang.date.ii") !!}
						</span>
					</div>
				</div>
				<div class="mb-4">
					<label
						class=""
						for=""
					>
						{!! __("lang.master.accepted_number.accepted_number") !!}
					</label>
					{!! Form::number('', '', [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="store"
					>
						{!! __("lang.button.submit") !!}
					</button>
					<button
						class="btn btn-light border border-secondary"
						type="reset"
						name=""
						value=""
					>
						{!! __("lang.button.cancel") !!}
					</button>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

        <!-- toolbar -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="">
                {!! __("lang.form.count") !!}：
                <span class="fw-bold">
                    {!! number_format($accepted_number_count) !!}
                </span>
            </div>
            <div class="">

            </div>
        </div>
        <!-- /.toolbar -->

        <table class="table">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">First</th>
                <th scope="col">Last</th>
                <th scope="col">Handle</th>
              </tr>
            </thead>
            <tbody class="table-group-divider">
                <tr>
                    <th scope="row">1</th>
                    <td>Mark</td>
                    <td>Otto</td>
                    <td>@mdo</td>
                </tr>
                <tr>
                    <th scope="row">2</th>
                    <td>Jacob</td>
                    <td>Thornton</td>
                    <td>@fat</td>
                </tr>
                <tr>
                    <th scope="row">3</th>
                    <td colspan="2">Larry the Bird</td>
                    <td>@twitter</td>
                </tr>
            </tbody>
        </table>

	</main>
	<!-- /.main -->

</div>


<!-- section -->
<section class="">

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
