@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		{!! Form::open($form) !!}
		{!! Form::hidden('', '', $mtb_accepted_number_id) !!}

		<div class="card mb-3">
			<div class="card-body">
                {!! echo '<pre>';print_r($error);die(); !!}
                @if ($errors->any())
                    <div
                        class="alert alert-danger"
                        role="alert"
                    >
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{!! $error !!}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

				<div class="mb-3">
					<label
						class=""
						for=""
					>
						{!! __("lang.master.accepted_number.time") !!}
					</label>
					<div class="input-group">
						{!! Form::select('accepted_number[hh]', ['' => ''] + $hour_list, '', [
							'class' => 'form-select',
						]) !!}
						<span class="input-group-text">
							{!! __("lang.date.hh") !!}
						</span>
						{!! Form::select('accepted_number[ii]', ['' => ''] + $minute_list, '', [
							'class' => 'form-select',
						]) !!}
						<span class="input-group-text">
							{!! __("lang.date.ii") !!}
						</span>
					</div>
				</div>
				<div class="mb-4">
					<label
						class=""
						for=""
					>
						{!! __("lang.master.accepted_number.accepted_number") !!}
					</label>
					{!! Form::number('accepted_number[accepted_number]', '', [
						'class' => 'form-control',
					]) !!}
				</div>
				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="store"
					>
						{!! __("lang.button.submit") !!}
					</button>
					<button
						class="btn btn-light border border-secondary"
						type="reset"
						name=""
						value=""
					>
						{!! __("lang.button.cancel") !!}
					</button>
				</div>

			</div>
		</div>

		{!! Form::close() !!}
	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

        <!-- toolbar -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="">
                {!! __("lang.form.count") !!}：
                <span class="fw-bold">
                    {!! number_format($accepted_number_count) !!}
                </span>
            </div>
            <div class="">

            </div>
        </div>
        <!-- /.toolbar -->

        <table class="table">
            <colgroup>
                <col>
                <col width="100%">
                <col>
            </colgroup>
            <thead>
              <tr>
                <th scope="col" nowrap>
                    &nbsp;
                </th>
                <th scope="col">
                    {!! __("lang.master.accepted_number.time") !!}
                </th>
                <th scope="col" nowrap>
                    {!! __("lang.master.accepted_number.accepted_number") !!}
                </th>
              </tr>
            </thead>
            <tbody class="table-group-divider">
                @if($accepted_number_count > 0)
                    @foreach($accepted_number as $key => $value)
                        <tr>
                            <th scope="row">

                            </th>
                            <td>Mark</td>
                            <td>Otto</td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <th scope="row" nowrap>
                            <div
                                class="btn-group btn-group-sm"
                                role="group"
                            >
                                <a
                                    class="btn btn-outline-secondary disabled"
                                    href=""
                                >
                                    {!! __("lang.button.edit") !!}
                                </a>
                            </div>
                        </th>
                        <td colspan="2">
                            {!! __("lang.error.empty") !!}
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>

	</main>
	<!-- /.main -->

</div>


<!-- section -->
<section class="">

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
