@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<!-- section -->
<section class="">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center mb-3">
		<div>
			<a
				class=""
				href="{!! route('admin.covid.master.date.index', [
					$date['prev']['yy'],
					$date['prev']['mm'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<h5 class="mx-3">
			{!! \Carbon\Carbon::create($yy, $mm, 1)->format(__("lang.date.yymm")) !!}
		</h5>
		<div>
			<a
				class=""
				href="{!! route('admin.covid.master.date.index', [
					$date['next']['yy'],
					$date['next']['mm'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

	<table class="table table-bordered">
		<thead>
			<tr class="text-center">
				@foreach(__("lang.dictionary.weekday_shortcode") as $key => $value)
					<th>
						<div class="fw-bold">
							{!! $value !!}
						</div>
					</th>
				@endforeach
			</tr>
		</thead>
		<tbody>
			<tr class="text-center">
				@php
					$cols = 1;
				@endphp
				@for($i = 1; $i <= ($date['day'] + $date['week']); $i++)
					@php
						$j = $i - $date['week'];
					@endphp

					@if($j < 1)
						<td class="p-2">
							&nbsp;
						</td>
					@else
						<td class="p-2">
							<div class="text-end mb-2">
								<span class="fs-5">{!! $j !!}</span>
							</div>
							<div class="d-grid gap-1">
								@foreach($vendor_list as $key => $value)
									<a
										class="btn btn-{!! (isset($stock_list[$j][$key])) ? 'primary' : 'outline-secondary' !!} btn-sm"
										href="{!! action('Backend\Covid\Master\DataController@edit', [
											$yy,
											$mm,
											$j,
										]) !!}"
									>
										<div class="small">
											<div class="float-start fw-bold">
												{!! $value !!}
											</div><br>
											<div class="float-end">

											</div>
										</div>
									</a>
								@endforeach
							</div>
						</td>
					@endif

					@if(($i % 7) == 0)
						@php
							$cols = 0;
						@endphp
						</tr>
						@if($j != $date['day'])
							<tr class="text-center">
						@endif
					@else
						@if($i == ($date['day'] + $date['week']))
							@for($k = ($cols + 1); $k <= 7; $k++)
								<td>&nbsp;</td>
							@endfor
						@endif
					@endif

					@php
						$cols++;
					@endphp
				@endfor
	</table>
	<!-- /.table -->

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
