@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<!-- section -->
<section class="">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center mb-3">
		<div>
			<a
				class=""
				href="{!! route('admin.covid.master.date.index', [
					$date['prev']['yy'],
					$date['prev']['mm'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<h5 class="mx-3">
			{!! \Carbon\Carbon::create($yy, $mm, 1)->format(__("lang.date.yymm")) !!}
		</h5>
		<div>
			<a
				class=""
				href="{!! route('admin.covid.master.date.index', [
					$date['next']['yy'],
					$date['next']['mm'],
				]) !!}"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

	<table class="table table-bordered">
		<thead>
			<tr class="text-center">
				@foreach(__("lang.dictionary.weekday_shortcode") as $key => $value)
					<th>
						<div class="fw-bold">
							{!! $value !!}
						</div>
					</th>
				@endforeach
			</tr>
		</thead>
		<tbody>
			<tr class="text-center">
				@php
					$cols = 1;
				@endphp
				@for($i = 1; $i <= ($date['day'] + $date['week']); $i++)
					@php
						$j = $i - $date['week'];
					@endphp

					@if($j < 1)
						<td class="p-2">
							&nbsp;
						</td>
					@else
						<td class="p-2">
							<div class="mb-2">
								<h5>{!! $j !!}</h5>
							</div>
							<div class="d-grid gap-1">

							</div>
						</td>
					@endif

					@if(($i % 7) == 0)
						@php
							$cols = 0;
						@endphp
						</tr>
						@if($j != $date['day'])
							<tr class="text-center">
						@endif
					@else
						@if($i == ($date['day'] + $date['week']))
							@for($k = ($cols + 1); $k <= 7; $k++)
								<td>&nbsp;</td>
							@endfor
						@endif
					@endif

					@php
						$cols++;
					@endphp
				@endfor
	</table>
	<!-- /.table -->

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
