@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<!-- section -->
<section class="">

	<div class="row">

		<aside class="col col-lg-2">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="text-center">
                    {!! \Carbon\Carbon::create(
                        $yy,
                        $mm,
                        1,
                    )->format(__("lang.date.yymm")) !!}
                </h5>
            </div>

			<div class="list-group">
				@for($i = 1; $i <= $date['day']; $i++)
					<a
						class="list-group-item list-group-item-action d-flex justify-content-between align-items-center {!! ($i == $dd) ? 'active' : '' !!}"
						href="{!! route('admin.covid.master.date.update', [
							$yy,
							$mm,
							$i,
						]) !!}"
					>
						<div>
							{!! implode('', [
								$i,
								__("lang.date.dd"),
							]) !!}（）
						</div>
						<div>
							@if(isset($date_list[$i]))
								<span class="">
									{!! $date_list[$i]['accepted_numbers'] !!}
								</span>
							@endif
						</div>
					</a>
				@endfor
			</div>

		</aside>

		<main class="col">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="text-center">
                    上限枠設定
                </h5>
            </div>

            <div class="card">
                <div class="card-body pb-0">

                    @foreach($accepted_number_list as $key => $value)
                        <div class="input-group mb-3">
                            <span class="input-group-text">
                                {!! \Carbon\Carbon::create(
                                    $yy,
                                    $mm,
                                    $dd,
                                    $value['hh'],
                                    $value['ii'],
                                )->format(__("lang.date.hhii")) !!}
                            </span>
                            {!! Form::number('', '', [
                                'class' => 'form-control',
                            ]) !!}
                            <span class="input-group-text">
                                人
                            </span>
                        </div>
                    @endforeach

                </div>
            </div>

		</main>

	</div>

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
