@extends('backend.layouts.main')

{{-- content --}}
@section('content')
<!-- section -->
<section class="">

	<div class="row">

		<aside class="col col-lg-2">

			<div class="d-flex justify-content-between align-items-center mb-3">
				<h5 class="text-center">
					{!! \Carbon\Carbon::create(
						$yy,
						$mm,
						1,
					)->format(__("lang.date.yymm")) !!}
				</h5>
			</div>

			<div class="list-group">
				@for($i = 1; $i <= $date['day']; $i++)
					<a
						class="list-group-item list-group-item-action d-flex justify-content-between align-items-center {!! ($i == $dd) ? 'active' : '' !!}"
						href="{!! route('admin.covid.master.date.update', [
							$yy,
							$mm,
							$i,
						]) !!}"
					>
						<div>
							{!! implode('', [
								$i,
								__("lang.date.dd"),
							]) !!}（）
						</div>
						<div>
							@if(isset($date_list[$i]))
								<span class="">
									{!! $date_list[$i]['accepted_numbers'] !!}
								</span>
							@endif
						</div>
					</a>
				@endfor
			</div>

		</aside>

		<main class="col">
			{!! Form::open($form) !!}
			{!! Form::hidden('date[mtb_date_id]', $date['mtb_date_id']) !!}
			{!! Form::hidden('date[yy]', $yy) !!}
			{!! Form::hidden('date[mm]', $mm) !!}
			{!! Form::hidden('date[dd]', $dd) !!}

			<div class="d-flex justify-content-between align-items-center mb-3">
				<h5 class="text-center">
					上限枠設定
				</h5>
			</div>

			<div class="card mb-3">
				<div class="card-body pb-0">

					@foreach($accepted_number_list as $key => $value)
						<div class="input-group mb-3">
							<span class="input-group-text fw-bold">
								{!! \Carbon\Carbon::create(
									$yy,
									$mm,
									$dd,
									$value['hh'],
									$value['ii'],
								)->format(__("lang.date.hhii")) !!}
							</span>
							{!! Form::number("time[{$value['hh']}][{$value['ii']}]", (isset($time_list[$value['hh']][$value['ii']])) ? $time_list[$value['hh']][$value['ii']]['accepted_number'] : $value['accepted_number'], [
								'class' => 'form-control',
								'id' => "time{$key}",
							]) !!}
							<span class="input-group-text">
								人
							</span>
							<button
								class="btn btn-outline-secondary"
								type="button"
								onclick="resetNumber({!! $key !!})"
							>
								<small>
									{!! __("lang.button.reset") !!}
								</small>
							</button>
						</div>
					@endforeach

				</div>
			</div>

			<div class="d-grid gap-2 col-6 mx-auto">
				<button
					class="btn btn-primary btn-lg"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.submit") !!}
					</span>
				</button>
			</div>

			{!! Form::close() !!}
		</main>

	</div>

</section>
<!-- /.section -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});

let resetNumber = (id) => {

	$('#time' + id).val(0);
};
</script>
@stop
