<table class="table table-bordered">
    <thead>
        <tr class="text-center">
            @foreach(__("lang.dictionary.weekday_shortcode") as $key => $value)
                <th>
                    <div class="fw-bold">
                        {!! $value !!}
                    </div>
                </th>
            @endforeach
        </tr>
    </thead>
    <tbody>
        <tr class="text-center">
            @php
                $cols = 1;
            @endphp
            @for($i = 1; $i <= ($date['day'] + $date['week']); $i++)
                @php
                    $j = $i - $date['week'];
                @endphp

                @if($j < 1)
                    <td class="p-2">
                        &nbsp;
                    </td>
                @else
                    <td class="p-2">
                        <div class="mb-2">
                            <h5>{!! $j !!}</h5>
                        </div>
                        <div class="d-grid">
                            <a
                                @if(isset($date_list[$j]))
                                    class="btn btn-primary btn-sm"
                                @else
                                    class="btn btn-light btn-sm border border-secondary"
                                @endif
                                href=""
                            >
                                {!! (isset($date_list[$j])) ? $date_list[$j]['accepted_numbers'] : '-' !!}
                            </a>
                        </div>
                    </td>
                @endif

                @if(($i % 7) == 0)
                    @php
                        $cols = 0;
                    @endphp

                    @if($j != $date['day'])
                        </tr>
                        <tr class="text-center">
                    @endif
                @else
                    @if($i == ($date['day'] + $date['week']))
                        @for($k = ($cols + 1); $k <= 7; $k++)
                            <td>&nbsp;</td>
                        @endfor
                    @endif
                @endif

                @php
                    $cols++;
                @endphp
            @endfor
    </tr>
</table>
<!-- /.table -->
