<!DOCTYPE html>
<html lang="{!! str_replace('_', '-', app()->getLocale()) !!}">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title></title>

	<!-- template -->
	<link
		href="{!! implode('/', [
			asset('templates'),
			'dashboard',
			'css',
			'sb-admin-2.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>

	{{-- bootstrap --}}
	@vite([
		'resources/sass/app.scss',
		'resources/js/app.js'
	])

    <!-- custom -->
    <link
		href="{!! implode('/', [
			asset('templates'),
			'dashboard',
			'css',
			'custom.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>

	<!-- font-awesome -->
	<link
		rel="stylesheet"
		href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
		integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
		crossorigin="anonymous"
		referrerpolicy="no-referrer"
	>

	@yield('css')
</head>
<body id="page-top" class="sidebar-toggled">
	<div id="wrapper">

		@include('backend.layouts.components.sidebar')

		<div id="content-wrapper" class="d-flex flex-column">
			<div id="content">

				@include('backend.layouts.components.topbar')

				<div class="container-fluid">
					@yield('content')
				</div>
			</div>

			@include('backend.layouts.components.footer')
		</div>

	</div>

	<!-- jquery -->
	<script
		src="{!! implode('/', [
			asset('vendors'),
			'jquery',
			'jquery.min.js',
		]) !!}"
	></script>

	<!-- jquery -->
	<script
		src="{!! implode('/', [
			asset('vendors'),
			'jquery-easing',
			'jquery.easing.min.js',
		]) !!}"
	></script>

	<!-- custom -->
	<script
		src="{!! implode('/', [
			asset('templates'),
			'dashboard',
			'js',
			'sb-admin-2.js',
		]) !!}?timestamp={!! date('YmdHis') !!}"
	></script>

	<script
		src="{!! implode('/', [
			asset('templates'),
			'dashboard',
			'js',
			'custom.js',
		]) !!}"
	></script>

	@yield('js')
</body>
</html>
