<!DOCTYPE html>
<html lang="{!! str_replace('_', '-', app()->getLocale()) !!}" class="h-100">
<head>
	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, shrink-to-fit=no">
	<title></title>

	{{-- bootstrap --}}
	{{-- @vite([
		'resources/sass/app.scss',
		'resources/js/app.js',
	]) --}}

	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">

	<link
		href="{!! implode('/', [
			asset('templates'),
			'page',
			'css',
			'custom.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>

	<!-- font-awesome -->
	<link
		href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
		rel="stylesheet"
		integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
		crossorigin="anonymous"
		referrerpolicy="no-referrer"
	>

    @yield('css')
</head>

<body class="d-flex flex-column h-100">

	@include('frontend.layouts.components.header')

	<!-- main -->
	<main class="flex-shrink-0">
		<div class="container p-3">
			@yield('content')
		</div>
	</main>
	<!-- /.main -->

	@include('frontend.layouts.components.footer')

	<!-- jquery -->
	<script
		src="https://code.jquery.com/jquery-3.6.0.slim.min.js"
		integrity="sha256-u7e5khyithlIdTpu22PHhENmPcRdFiHRjhAuHcs05RI="
		crossorigin="anonymous"
	></script>

	<!-- jquery -->
	<script
		src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
		integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4"
		crossorigin="anonymous"
	></script>

    @yield('js')
</body>
</html>
