<!DOCTYPE html>
<html lang="{!! str_replace('_', '-', app()->getLocale()) !!}" class="h-100">
<head>
	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, shrink-to-fit=no">
	<title></title>

	{{-- bootstrap --}}
	@vite([
        'resources/sass/app.scss',
        'resources/js/app.js'
    ])

	<link
		href="{!! implode('/', [
			asset('templates'),
			'mobile',
			'css',
			'ui.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>
    <link
		href="{!! implode('/', [
			asset('templates'),
			'mobile',
			'css',
			'custom.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>

    @yield('css')
</head>

<body>

    <!-- preloader-->
    <div class="preloader" id="preloader">
        <div class="spinner-grow" role="status">
        <span class="visually-hidden">Loading...</span>
        </div>
    </div>
    <!-- /.preloader -->

	@include('frontend.layouts.components.header')

	<!-- main -->
	<main class="app-content">
		<div class="container">
			@yield('content')
		</div>
	</main>
	<!-- /.main -->

	<!-- jquery -->
	<script
		src="{!! implode('/', [
			asset('vendors'),
			'jquery',
			'jquery.min.js',
		]) !!}"
	></script>

	<!-- custom -->
	<script
		src="{!! implode('/', [
			asset('templates'),
			'mobile',
            'js',
			'script.js',
		]) !!}"
	></script>
    <script
		src="{!! implode('/', [
			asset('templates'),
			'mobile',
            'js',
			'pwa.js',
		]) !!}"
	></script>

    @yield('js')
</body>
</html>
