@extends('frontend.layouts.default')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">
	<div class="container">

        <div
            class="alert alert-warning"
            role="alert"
        >
            <h4 class="alert-heading text-center mb-3">
                接種会場、ならびにワクチン種類のご案内
            </h4>
            <p class="mb-0">
                利用規約、ならびに個人情報保護方針をご一読いただき、ご同意いただいた上で「同意する」ボタンをタップして次におすすみください。
            </p>
        </div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title text-center">
            <h3>
                接種会場
            </h3>
        </div>
        <div class="card mb-5">
            <div class="card-body text-center">
                <p class="fs-2 fw-bold mb-0">
                    平和台病院
                </p>
            </div>
        </div>

        <div class="section-title text-center">
            <h3>
                ワクチン種類
            </h3>
        </div>
        <div class="card">
            <div class="card-body text-center">
                <p class="fs-2 fw-bold mb-0">
                    モデルナBA4・5
                </p>
            </div>
        </div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="{!! action('MocupController@form2') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.consent") !!}
			</span>
		</a>
        <a
			class="btn btn-light btn-lg border border-secondary w-100"
			href="{!! action('MocupController@home') !!}"
		>
			<span class="fw-bold text-dark">
				{!! __("lang.button.back") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<script>
$(function(){


});
</script>
@stop
