@extends('frontend.layouts.default')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">
	<div class="container">

		<div
			class="alert alert-warning"
			role="alert"
		>
			<h4 class="alert-heading text-center mb-3">
				接種会場、ならびにワクチン種類のご案内
			</h4>
			<p class="mb-0">
				接種会場、ならびにワクチン接種をご確認いただき、ご承諾いただいた上で「承諾する」ボタンをタップして次におすすみください。<br>
				なお、接種会場、ならびにワクチン接種を変更することはできません。
			</p>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="card mb-3">
			<div class="card-body text-center">
				<h3 class="mb-3">
					接種会場
				</h3>
				<p class="fs-2 fw-bold mb-0">
					平和台病院
				</p>
			</div>
		</div>

		<div class="card">
			<div class="card-body text-center">
				<h3 class="mb-3">
					ワクチン種類
				</h3>
				<p class="fs-2 fw-bold mb-0">
					モデルナBA4・5
				</p>
			</div>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="{!! action('MocupController@form2') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.consent") !!}
			</span>
		</a>
		<a
			class="btn btn-light btn-lg border border-secondary w-100"
			href="{!! action('MocupController@home') !!}"
		>
			<span class="fw-bold text-dark">
				{!! __("lang.button.back") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<script>
$(function(){


});
</script>
@stop
