@extends('frontend.layouts.default')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title text-center">
            <h3>
                前回接種日
            </h3>
        </div>
        <div class="mb-0">
            <div class="input-group input-group-lg">
                {!! Form::selectRange('', 2020, 2023, date('Y'), [
                    'class' => 'form-select',
                ]) !!}
                {!! Form::selectRange('', 1, 12, date('n'), [
                    'class' => 'form-select',
                ]) !!}
                {!! Form::selectRange('', 1, 31, date('j'), [
                    'class' => 'form-select',
                ]) !!}
            </div>
        </div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title text-center">
            <h3>
                今回接種回数
            </h3>
        </div>
        <ul class="list-group">
            @for($i = 1; $i <= 5; $i++)
                <li class="list-group-item py-3">
                    {!! Form::radio('rdo', '', false, [
                        'class' => 'form-check-input me-1',
                    ]) !!}
                </li>
            @endfor
        </ul>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="{!! action('MocupController@form1') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.consent") !!}
			</span>
		</a>
        <a
			class="btn btn-outline-primary btn-lg w-100"
			href="{!! action('MocupController@home') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.back") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<script>
$(function(){


});
</script>
@stop
