@extends('frontend.layouts.default')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title text-center">
            <h3>
                希望日
            </h3>
        </div>
        <div class="mb-0">
            <div
                class="btn-group"
                role="group"
            >
                @for($i = 1; $i <= 30; $i++)
                    {!! Form::radio('day', '', false, [
                        'class' => 'btn-check',
                        'id' => "day{$i}",
                        'autocomplete' => 'off',
                    ]) !!}
                    <label
                        class="btn btn-outline-primary"
                        for="day{!! $i !!}"
                    >
                        <div class="text-nowrap">
                            <ul class="list-unstyled fw-bold lead mb-0">
                                <li class="">
                                    <span class="fs-2">
                                        {!! $i !!}
                                    </span>日
                                </li>
                                <li class="mb-2">
                                    （月）
                                </li>
                                <li class="">
                                    <i class="fa-regular fa-circle fa-fw fa-2x"></i>
                                </li>
                            </ul>
                        </div>
                    </label>
                @endfor
            </div>
            </div>
        </div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title text-center">
            <h3>
                希望時間
            </h3>
        </div>

        <div class="mb-0">
            {!! Form::select('', $time_list, null, [
                'class' => 'form-select form-select-lg',
            ]) !!}

            @foreach($time_list as $key => $value)
                <div class="mb-2">
                    {!! Form::radio('rdo', '', false, [
                        'class' => 'btn-check',
                        'id' => "day{$key}",
                        'autocomplete' => 'off',
                    ]) !!}
                    <label
                        class="btn btn-outline-primary w-100"
                        for="rdo{!! $i !!}"
                    >
                        <span class="fw-bold" style="font-size:1.2rem;">
                            {!! $value !!}
                        </span>
                    </label>
                </div>
            @endforeach
        </div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="{!! action('MocupController@form3') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.next") !!}
			</span>
		</a>
        <a
			class="btn btn-outline-primary btn-lg w-100"
			href="{!! action('MocupController@form1') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.back") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<script>
$(function(){


});
</script>
@stop
