@extends('frontend.layouts.default')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title text-center">
            <h3>
                接種券番号
            </h3>
        </div>
        <div class="mb-3">
            <label
                class="form-label"
                for=""
            >
                <span class="fw-bold">
                    接種券番号
                </span>
            </label>
            {!! Form::text('', '', [
                'class' => 'form-control form-control-lg',
            ]) !!}
        </div>

        <p class="fw-bold mb-1">
            カメラアプリで接種券番号を読み取ることができます。
        </p>
        <div class="mb-3">
            <label
                class="btn btn-outline-secondary btn-lg w-100"
                for="camera"
            >
                <span class="fw-bold">
                    カメラアプリを起動する
                </span>
            </label>
            {!! Form::file('', [
                'class' => 'd-none',
                'id' => 'camera',
                'accept' => 'image/*',
                'capture' => 'camera',
            ]) !!}
        </div>
        <p class="text-danger">
            ※ Androidのスマホの場合は、機種によってはカメラアプリがQRコードの読み取りに対応していないことがあります。
        </p>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="{!! action('MocupController@form2') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.consent") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<script>
$(function(){


});
</script>
@stop
