@extends('frontend.layouts.default')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="section-title text-center">
			<h3>
				接種券番号
			</h3>
		</div>
		<div class="mb-3">
			<label
				class="form-label"
				for=""
			>
                <span class="badge rounded-pill text-bg-danger">
                    {!! __("lang.form.required") !!}
                </span>
				<span class="fw-bold">
					接種券番号
				</span>
			</label>
			{!! Form::text('', '', [
				'class' => 'form-control form-control-lg',
			]) !!}
		</div>

		<p class="fw-bold mb-1">
			カメラアプリで接種券番号を読み取ることができます。
		</p>
		<div class="mb-3">
			<label
				class="btn btn-outline-secondary btn-lg w-100"
				for="camera"
			>
				<span class="fw-bold">
					カメラアプリを起動する
				</span>
			</label>
			{!! Form::file('', [
				'class' => 'd-none',
				'id' => 'camera',
				'accept' => 'image/*',
				'capture' => 'camera',
			]) !!}
		</div>

		<div class="alert alert-primary">
			<h4 class="alert-heading text-center mb-3">
				接種券番号の読み取り方
			</h4>
			<ol class="mb-0 ps-3">
				<li>
					「カメラアプリを起動する」ボタンをタップしてカメラアプリを起動する
				</li>
				<li>
					接種券に記載されているQRコードを読み取る
				</li>
				<li>
					読み取りが成功すると、「接種券番号」欄に接種券番号が自動で表示される
				</li>
			</ol>
		</div>

		<div class="alert alert-warning">
			<h4 class="alert-heading text-center mb-3">
				Androidユーザの方へ
			</h4>
			<p class="mb-0">
				Androidのスマホの場合は、機種によってはカメラアプリがQRコードの読み取りに対応していないことがあります。<br>
				その場合はカメラアプリで接種券を撮影して、撮影した接種券の写真を指定してください。
			</p>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="{!! action('MocupController@form6') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.next") !!}
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')

@stop

{{-- js --}}
@section('js')
<script>
$(function(){


});
</script>
@stop
