<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/bootstrap', function () {
    return view('bootstrap');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/**
 * ==================================================
 * frontend
 * ==================================================
 */
Route::prefix('/')
    //->middleware('auth')
    ->name('book.')
    ->namespace('Frontend')
    ->group(function () {

        //
        Route::get('/index', [BookController::class, 'index'])->name('index');

        //
        Route::get('/create', [BookController::class, 'create'])->name('create');
});


/**
 * ==================================================
 * backend
 * ==================================================
 */
Route::prefix('admin')
    //->middleware('auth')
    ->name('admin.')
    ->namespace('Backend')
    ->group(function () {

        //
        Route::get('', [SigninController::class, 'index'])
            ->name('signin.index');

        //
        Route::get('store', [SigninController::class, 'store'])
            ->name('signin.store');

        /**
         *
         */
        Route::group(['middleware' => 'backend'], function () {

        });
});
