<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Backend\SigninController;
use App\Http\Controllers\Backend\HomeController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
	return view('welcome');
});

Route::get('/bootstrap', function () {
	return view('bootstrap');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/**
 * ==================================================
 * frontend
 * ==================================================
 */
Route::prefix('/')
	//->middleware('auth')
	->name('frontend.')
	->namespace('Frontend')
	->group(function () {

	/**
	 * --------------------------------------------------
	 * covid
	 * --------------------------------------------------
	 */
	Route::prefix('covid')
		->name('covid.')
		->namespace('Covid')
		->group(function () {

	});

	/**
	 * --------------------------------------------------
	 * flu
	 * --------------------------------------------------
	 */
	Route::prefix('flu')
		->name('flu.')
		->namespace('Flu')
		->group(function () {

	});
});


/**
 * ==================================================
 * backend
 * ==================================================
 */
Route::prefix('admin')
	->name('admin.')
	->namespace('Backend')
	->group(function () {

	// signin
	Route::get('', [SigninController::class, 'index'])
		->name('signin.index');

	// Route::middleware('auth')
	//     ->group(function () {

		// home
		Route::get('home', [HomeController::class, 'index'])
			->name('home.index');
	// });
});
