<?php

use Illuminate\Support\Facades\Route;

// frontend

// backend
use App\Http\Controllers\Backend\SigninController;
use App\Http\Controllers\Backend\HomeController;
use App\Http\Controllers\Backend\Covid\CalendarController;
use App\Http\Controllers\Backend\Covid\BookingController;
use App\Http\Controllers\Backend\Covid\MasterController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
	return view('welcome');
});

Route::get('/bootstrap', function () {
	return view('bootstrap');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/**
 * ==================================================
 * frontend
 * ==================================================
 */
Route::prefix('/')
	//->middleware('auth')
	->name('frontend.')
	->namespace('Frontend')
	->group(function () {

	/**
	 * --------------------------------------------------
	 * covid
	 * --------------------------------------------------
	 */
	Route::prefix('covid')
		->name('covid.')
		->namespace('Covid')
		->group(function () {

	});

	/**
	 * --------------------------------------------------
	 * flu
	 * --------------------------------------------------
	 */
	Route::prefix('flu')
		->name('flu.')
		->namespace('Flu')
		->group(function () {

	});
});


/**
 * ==================================================
 * backend
 * ==================================================
 */
Route::prefix('admin')
	->name('admin.')
	->namespace('Backend')
	->group(function () {

	// signin
	Route::get('', [SigninController::class, 'index'])
		->name('signin.index');

	Route::post('signin/store', [SigninController::class, 'store'])
		->name('signin.store');

	/**
	 * --------------------------------------------------
	 * middleware
	 * --------------------------------------------------
	 */
	// Route::middleware('backend')
	//     ->group(function () {

		// home
		Route::get('home', [HomeController::class, 'index'])
			->name('home.index');

		/**
		 * --------------------------------------------------
		 * covid
		 * --------------------------------------------------
		 */
		Route::prefix('covid')
			->name('covid.')
			->namespace('Covid')
			->group(function () {

				// calendar
				Route::get('calendar/index/{yy?}/{mm?}', [CalendarController::class, 'index'])
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+')
					->name('calendar.index');

				// booking
				Route::get('booking/index/{yy?}/{mm?}/{dd?}', [BookingController::class, 'index'])
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+')
					->where('dd', '[-0-9A-Za-z_.\s]+')
					->name('booking.index');

				Route::post('booking/store', [BookingController::class, 'store'])
					->name('booking.store');

				Route::get('booking/show/{booking_code}', [BookingController::class, 'show'])
					->where('booking_code', '[-0-9A-Za-z_.\s]+')
					->name('booking.show');

				Route::get('booking/update/{booking_code?}', [BookingController::class, 'update'])
					->where('booking_code', '[-0-9A-Za-z_.\s]+')
					->name('booking.update');

				Route::get('booking/destroy/{booking_code}', [BookingController::class, 'destroy'])
					->where('booking_code', '[-0-9A-Za-z_.\s]+')
					->name('booking.destroy');

				// master
				Route::get('master/index', [MasterController::class, 'index'])
					->name('master.index');

                Route::post('master/store', [MasterController::class, 'store'])
					->name('master.store');

                Route::get('master/show/{table}', [MasterController::class, 'show'])
					->where('table', '[-0-9A-Za-z_.\s]+')
					->name('master.show');

				/**
				 * --------------------------------------------------
				 * master
				 * --------------------------------------------------
				 */
				Route::prefix('master')
					->name('master.')
					->namespace('Master')
					->group(function () {


					});
			});
	// });
});
