<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
	return view('welcome');
});

Route::get('/bootstrap', function () {
	return view('bootstrap');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/**
 * ==================================================
 * frontend
 * ==================================================
 */
Route::prefix('/')
	//->middleware('auth')
	->name('frontend.')
	->namespace('Frontend')
	->group(function () {

	/**
	 * --------------------------------------------------
	 * covid
	 * --------------------------------------------------
	 */
	Route::prefix('covid')
		->name('covid.')
		->namespace('Covid')
		->group(function () {

	});

	/**
	 * --------------------------------------------------
	 * flu
	 * --------------------------------------------------
	 */
	Route::prefix('flu')
		->name('flu.')
		->namespace('Flu')
		->group(function () {

	});
});


/**
 * ==================================================
 * backend
 * ==================================================
 */
Route::prefix('admin')
	->name('admin.')
	->namespace('Backend')
	->group(function () {

	// signin
	Route::name('signin.index')
        ->get('', 'SigninController@index');

	Route::name('signin.store')
        ->post('signin/store', 'SigninController@store');

	/**
	 * --------------------------------------------------
	 * middleware
	 * --------------------------------------------------
	 */
	// Route::middleware('backend')
	//     ->group(function () {

		// home
		Route::name('home.index')
            ->get('home', 'HomeController@index');

		// master
		Route::name('master.index')
            ->get('master/index', 'MasterController@store');

		/**
		 * --------------------------------------------------
		 * covid
		 * --------------------------------------------------
		 */
		Route::prefix('covid')
			->name('covid.')
			->namespace('Covid')
			->group(function () {

			// calendar
			Route::name('calendar.index')
                ->get('calendar/index/{yy?}/{mm?}', 'CalendarController@index')
				->where('yy', '[-0-9A-Za-z_.\s]+')
				->where('mm', '[-0-9A-Za-z_.\s]+');

			// booking
			Route::name('booking.index')
                ->get('booking/index/{yy?}/{mm?}/{dd?}', 'BookingController@index')
				->where('yy', '[-0-9A-Za-z_.\s]+')
				->where('mm', '[-0-9A-Za-z_.\s]+')
				->where('dd', '[-0-9A-Za-z_.\s]+');

			Route::name('booking.store')
                ->post('booking/store', 'BookingController@store');

			Route::name('booking.show')
                ->get('booking/show/{booking_code}', 'BookingController@show')
				->where('booking_code', '[-0-9A-Za-z_.\s]+');

			Route::name('booking.update')
                ->get('booking/update/{booking_code?}', 'BookingController@update')
				->where('booking_code', '[-0-9A-Za-z_.\s]+');

			Route::get('booking/destroy/{booking_code}', [BookingController::class, 'destroy'])
				->where('booking_code', '[-0-9A-Za-z_.\s]+')
				->name('booking.destroy');

			// master
			Route::get('master/index', [MasterController::class, 'index'])
				->name('master.index');

			Route::post('master/store', [MasterController::class, 'store'])
				->name('master.store');

			Route::get('master/show/{table}/{id?}', [MasterController::class, 'show'])
				->where('table', '[-0-9A-Za-z_.\s]+')
				->where('id', '[-0-9A-Za-z_.\s]+')
				->name('master.show');

			/**
			 * --------------------------------------------------
			 * master
			 * --------------------------------------------------
			 */
			Route::prefix('master')
				->name('master.')
				->namespace('Master')
				->group(function () {

				// accepted_number
				Route::get('acceptednumber/index', [AcceptedNumberController::class, 'index'])
					->name('acceptednumber.index');

				Route::post('acceptednumber/store', [AcceptedNumberController::class, 'store'])
					->name('acceptednumber.store');

				// date
				Route::get('date/index/{yy?}/{mm?}', [DateController::class, 'index'])
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+')
					->name('date.index');

				Route::post('date/store', [DateController::class, 'store'])
					->name('date.store');

				Route::get('date/update/{yy}/{mm}/{dd}', [DateController::class, 'update'])
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+')
					->where('dd', '[-0-9A-Za-z_.\s]+')
					->name('date.update');
			});
		});

	// });
});
