<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
	return view('welcome');
});

Route::get('/bootstrap', function () {
	return view('bootstrap');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/**
 * ==================================================
 * frontend
 * ==================================================
 */
Route::prefix('/')
	//->middleware('auth')
	->name('frontend.')
	->namespace('Frontend')
	->group(function () {

	/**
	 * --------------------------------------------------
	 * covid
	 * --------------------------------------------------
	 */
	Route::prefix('covid')
		->name('covid.')
		->namespace('Covid')
		->group(function () {

	});

	/**
	 * --------------------------------------------------
	 * flu
	 * --------------------------------------------------
	 */
	Route::prefix('flu')
		->name('flu.')
		->namespace('Flu')
		->group(function () {

	});
});


/**
 * ==================================================
 * backend
 * ==================================================
 */
Route::prefix('admin')
	->name('admin.')
	->namespace('Backend')
	->group(function () {

	// signin
	Route::name('signin.index')
		->get('', 'SigninController@index');

	Route::name('signin.store')
		->post('signin/store', 'SigninController@store');

	/**
	 * --------------------------------------------------
	 * middleware
	 * --------------------------------------------------
	 */
	// Route::middleware('backend')
	//     ->group(function () {

		// home
		Route::name('home.index')
			->get('home', 'HomeController@index');

		// master
		Route::name('master.index')
			->get('master/index', 'MasterController@store');

		/**
		 * --------------------------------------------------
		 * covid
		 * --------------------------------------------------
		 */
		Route::prefix('covid')
			->name('covid.')
			->namespace('Covid')
			->group(function () {

			// calendar
			Route::name('calendar.index')
				->get('calendar/index/{yy?}/{mm?}', 'CalendarController@index')
				->where('yy', '[-0-9A-Za-z_.\s]+')
				->where('mm', '[-0-9A-Za-z_.\s]+');

			// booking
			Route::name('booking.index')
				->get('booking/index/{yy?}/{mm?}/{dd?}', 'BookingController@index')
				->where('yy', '[-0-9A-Za-z_.\s]+')
				->where('mm', '[-0-9A-Za-z_.\s]+')
				->where('dd', '[-0-9A-Za-z_.\s]+');

			Route::name('booking.store')
				->post('booking/store', 'BookingController@store');

			Route::name('booking.show')
				->get('booking/show/{booking_code}', 'BookingController@show')
				->where('booking_code', '[-0-9A-Za-z_.\s]+');

			Route::name('booking.update')
				->get('booking/update/{booking_code?}', 'BookingController@update')
				->where('booking_code', '[-0-9A-Za-z_.\s]+');

			Route::name('booking.destroy')
				->get('booking/destroy/{booking_code}', 'BookingController@destroy')
				->where('booking_code', '[-0-9A-Za-z_.\s]+');

			// master
			Route::name('master.index')
				->get('master/index', 'MasterController@index');

			Route::name('master.store')
				->post('master/store', 'MasterController@store');

			Route::name('master.show')
				->get('master/show/{table}/{id?}', 'MasterController@show')
				->where('table', '[-0-9A-Za-z_.\s]+')
				->where('id', '[-0-9A-Za-z_.\s]+');

			/**
			 * --------------------------------------------------
			 * master
			 * --------------------------------------------------
			 */
			Route::prefix('master')
				->name('master.')
				->namespace('Master')
				->group(function () {

				// accepted_number
				Route::name('acceptednumber.index')
					->get('acceptednumber/index/{mtb_accepted_number_id?}', 'AcceptedNumberController@index')
					->where('mtb_accepted_number_id', '[-0-9A-Za-z_.\s]+');

				Route::name('acceptednumber.store')
					->post('acceptednumber/store', 'AcceptedNumberController@store');

				// date
				Route::name('date.index')
					->get('date/index/{yy?}/{mm?}', 'DateController@index')
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+');

				Route::name('date.store')
					->post('date/store', 'DateController@store');

				Route::name('date.update')
					->get('date/update/{yy}/{mm}/{dd}', 'DateController@update')
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+')
					->where('dd', '[-0-9A-Za-z_.\s]+');
			});
		});

	// });
});
