<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class HiraganaConvertCommand extends Command
{
	/**
	 * The name and signature of the console command.
	 *
	 * @var string
	 */
	protected $signature = 'app:hiragana-convert-command';

	/**
	 * The console command description.
	 *
	 * @var string
	 */
	protected $description = 'Command description';

	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		parent::__construct();

		$this->statement = $statement;
		$this->view = $view;
	}

	/**
	 * Execute the console command.
	 */
	public function handle()
	{
		$booking_list = $this->statement->get(
			$keys = [
				['is_booked', '=', 1],
			],
			$orders = [],
			$table = 'dtb_booking'
		);
		// dd($booking_list);

		foreach ($booking_list as $booking) {
			// dd($booking);

			// initialized
			$flag = 0;

			if (preg_match('/^[ァ-ヾ]+$/u', $booking['patient_skana'])) {
				// dd($booking['patient_skana']);

				$flag = 1;

				// converting Katakana to Hiragana
				$booking['patient_skana'] = mb_convert_kana($booking['patient_skana'], 'c');
				// dd($booking['patient_skana']);
			}

			if (preg_match('/^[ァ-ヾ]+$/u', $booking['patient_gkana'])) {
				// dd($booking['patient_gkana']);

				$flag = 1;

				// converting Katakana to Hiragana
				$booking['patient_gkana'] = mb_convert_kana($booking['patient_gkana'], 'c');
				// dd($booking['patient_gkana']);
			}

			if ($flag) {

				$return = $this->statement->update(
					$keys = [
						['dtb_booking_id', '=', $booking['dtb_booking_id']],
					],
					$values = [
						'patient_skana' => $booking['patient_skana'],
						'patient_gkana' => $booking['patient_gkana'],
					],
					$table = 'dtb_booking'
				);
				// dd($return);
			}
		}

		die('completed.');
	}
}
