<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

// use components
use Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use repository interfaces
use App\Repositories\Statement,
	App\Repositories\View;

class MunicipalityCommand extends Command
{
	/**
	 * The name and signature of the console command.
	 *
	 * @var string
	 */
	protected $signature = 'app:municipality-command';

	/**
	 * The console command description.
	 *
	 * @var string
	 */
	protected $description = 'Command description';

	protected
		$statement,
		$view;

	/**
	 * --------------------------------------------------
	 * @param object $statement
	 * @param object $view
	 * --------------------------------------------------
	 */
	public function __construct(
		Statement $statement,
		View $view
	) {
		parent::__construct();

		$this->statement = $statement;
		$this->view = $view;
	}

	/**
	 * Execute the console command.
	 */
	public function handle()
	{
		// initialized
		$values = [];

		// set file_path
		$file_path = implode('/', [
			storage_path(),
			'app',
			'public',
			'imports',
			'municipality.csv',
		]);
		//echo '<pre>';print_r($file_path);die();

		$file = new \SplFileObject($file_path);

		$file->setFlags(
			\SplFileObject::READ_CSV |
			\SplFileObject::READ_AHEAD |
			\SplFileObject::SKIP_EMPTY |
			\SplFileObject::DROP_NEW_LINE
		);

		foreach ($file as $i => $line) {
			//echo '<pre>';print_r($line);die();

			$values[] = [
				'municipality_code' => $line[0],
				'pref_name' => $line[1],
				'pref_kana' => mb_convert_kana($line[3], 'ASKV'),
				'ward_name' => $line[2],
				'ward_kana' => mb_convert_kana($line[4], 'ASKV'),
			];
			//echo '<pre>';print_r($values);die();
		}

		// set table
		$table = 'mtb_municipality';

		// truncate processing
		$this->statement->truncate(
			$table
		);

		// insert processing
		$this->statement->inserts(
			$values,
			$table
		);

		die('done');
	}
}
