<?php

namespace App;

use Illuminate\Support\Facades\Mail,
	Illuminate\Support\Facades\Http,
	Illuminate\Support\Str,
	Config,
	Request,
	Carbon\Carbon,
	Jenssegers\Agent\Agent;

class Helper
{
	/**
	 * ==================================================
	 * date
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param date $date
	 * --------------------------------------------------
	 */
	static public function getDate($date = null)
	{
		$result = [
			'date' => $date,
			'yy' => Carbon::create($date)->format('Y'),
			'mm' => Carbon::create($date)->format('n'),
			'dd' => Carbon::create($date)->format('j'),
			'hh' => Carbon::create($date)->format('H'),
			'ii' => Carbon::create($date)->format('i'),
		];

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $yy
	 * @param int $mm
	 * @param int $dd
	 * --------------------------------------------------
	 */
	static public function createDate($yy, $mm, $dd)
	{
		$result = Carbon::create(
			$yy,
			$mm,
			$dd,
			0,
			0,
			0
		)->toDateString();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $year
	 * @param int $month
	 * @param int $day
	 * @param int $hour
	 * @param int $minute
	 * @param int $second
	 * --------------------------------------------------
	 */
	static public function createDateTime($yy, $mm, $dd, $hh = 0, $ii = 0, $ss = 0)
	{
		$result = Carbon::create(
			$yy,
			$mm,
			$dd,
			$hh,
			$ii,
			$ss
		)->toDateTimeString();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $from
	 * @param int $to
	 * --------------------------------------------------
	 */
	static public function getYearList($from = null, $to = null)
	{
		$result = [];

		$from = (is_null($from)) ? Carbon::now()->subYear()->format('Y') : $from;
		$to = (is_null($to)) ? Carbon::now()->addYear()->format('Y') : $to;

		for ($i = $from; $i <= $to; $i++) {
			$result[$i] = implode('', [
				$i,
				__("lang.date.yy"),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param
	 * --------------------------------------------------
	 */
	static public function getMonthList()
	{
		for ($i = 1; $i <= 12; $i++) {

			$result[$i] = implode('', [
				$i,
				__("lang.date.mm"),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $dd
	 * --------------------------------------------------
	 */
	static public function getDayList($dd = 31)
	{
		for ($i = 1; $i <= 31; $i++) {

			$result[$i] = implode('', [
				$i,
				__("lang.date.dd"),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param date $birthday
	 * --------------------------------------------------
	 */
	static public function getAge($birthday)
	{
		$result = null;

		if (!is_null($birthday)) {

			$date = Carbon::parse($birthday);
			$result = $date->age;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param date $from
	 * @param date $to
	 * --------------------------------------------------
	 */
	static public function getDateDiff($from, $to)
	{
		$from = strtotime($from);
		$to = strtotime($to);

		// * 差を24（時間）×60（分）×60（秒）で割る
		$result = ($to - $from) / 86400 + 1;

		if ($result < 0) {
			$result = 0;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $hh
	 * @param int $ii
	 * --------------------------------------------------
	 */
	static public function getMeridiem($hh = null, $ii = null)
	{
		$result = 0;

		if (is_null($hh) && is_null($ii)) {

			$return = Carbon::now()->format('a');
		} else {

			$return = Carbon::create(
				date('Y'),
				date('n'),
				date('j'),
				$hh,
				$ii
			)->format('a');
		}
		//echo '<pre>';print_r($return);die();

		if ($return == 'pm') $result = 1;

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $yy
	 * @param int $mm
	 * @param array $response_list
	 * @return	none
	 * --------------------------------------------------
	 */
	static public function renderCalendar($yy, $mm, $response_list = [])
	{
		// set result;
		$result = '';

		// set date
		$sdate = Carbon::create($yy, $mm, 1)->toDateString();
		$edate = Carbon::create($yy, ($mm + 1), 0)->toDateString();
		$day = date("j", strtotime($edate));
		$week = date("w", strtotime($sdate));
		$cols = 1;

		for ($i = 1; $i <= ($day + $week); $i++) {

			$j = $i - $week;

			if ($j < 1) {

				$result .= "<td><div class=\"p-2\">&nbsp;</div></td>\n";
			} else {

				$w = date('w', strtotime(Carbon::create($yy, $mm, $i)->toDateString()));
				$today = ($yy == date('Y') && $mm == date('n') && $j == date('j')) ? 'bg-primary bg-opacity-10' : '';
				$color = (isset($response_list[$j])) ? 'primary' : 'secondary';
				$action = action('Backend\Log\SectionController@show', [
					$section_code,
					$yy,
					$mm,
					$j,
				]);

				$result .= "<td class=\"$today\">
					<a href=\"$action\" class=\"text-dark cell\">
						<div class=\"p-2\">
							<h4 class=\"text-$color mb-2 pb-1 border-$color border-bottom border-3\">
								$j
							</h4>
							<ul class=\"list-unstyled mb-0\">
								<li>
									午前：<span class=\"fw-bold\">" . ((isset($response_list[$j])) ? $response_list[$j]['am'] : 0) . "</span>
								</li>
								<li>
									午後：<span class=\"fw-bold\">" . ((isset($response_list[$j])) ? $response_list[$j]['pm'] : 0) . "</span>
								</li>
							</ul>
						</div>
					</a>
				</td>";
			}

			if (($i % 7) == 0) {
				$cols = 0;
				$result .= "</tr>\n";
				if ($j != $day) $result .= "<tr class=\"text-center\">\n";
			} else {
				if ($i == ($day + $week)) {
					for ($k = ($cols + 1); $k <= 7; $k++) {
						$result .= "<td><div class=\"p-2\">&nbsp;</div></td>\n";
					}
					$result .= "</tr>\n";
				}
			}

			$cols++;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * text
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param string $string
	 * --------------------------------------------------
	 */
	static public function convert2Kana($string)
	{
		return mb_convert_kana(
			$string,
			'C',
			'utf-8'
		);
	}

	/**
	 * --------------------------------------------------
	 * @param string $string
	 * --------------------------------------------------
	 */
	static public function removeCRLF($string)
	{
		return preg_replace(array("/\r\n/", "/\r/", "/\n/"), '', $string);
	}

	/**
	 * --------------------------------------------------
	 * @param string $string
	 * --------------------------------------------------
	 */
	static public function removeHyphen($string)
	{
		$result = preg_replace(
			"/[\x{207B}\x{208B}\x{2010}\x{2012}\x{2013}\x{2014}\x{2015}\x{2212}\x{2500}\x{2501}\x{2796}\x{30FC}\x{3161}\x{FF0D}\x{FF70}]/u",
			'',
			mb_convert_encoding($string, 'UTF-8', 'auto')
		);

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * number
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param int $number
	 * @param int $total
	 * @param int $precision
	 * --------------------------------------------------
	 */
	static public function num2per($number, $total = 100, $precision = 0)
	{
		$result = 0;

		if ($number > 0) {

			$result = number_format(($number / $total) * 100, 0);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param int $string
	 * --------------------------------------------------
	 */
	static public function sanitizeNumber($string)
	{
		$result = mb_convert_kana($string, 'kn');
		$result = preg_replace('/[^0-9]/', '', $result);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function getProgress($step)
	{
		$result = [];

		// set percent
		$percent = round((100 / Config::get('consts.step')), 2) * $step;
		//echo '<pre>';print_r($percent);die();

		$result = [
			'step' => $step,
			'percent' => $percent,
		];

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * file
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param string $file
	 * @param string $directory
	 * --------------------------------------------------
	 */
	static public function uploadFile($file, $directory)
	{
		$base_name = Str::random(32);
		$extension = \File::extension($file->getClientOriginalName());
		$file_name = implode('.', [$base_name, $extension]);

		// saving file
		$file->storeAs(
			$directory,
			$file_name,
			'public'
		);

		return $file_name;
	}

	/**
	 * --------------------------------------------------
	 * @param string $file
	 * --------------------------------------------------
	 */
	static public function removeExtension($file)
	{
		$file_name = pathinfo($file, PATHINFO_FILENAME);

		return $file_name;
	}

	/**
	 * --------------------------------------------------
	 * @param int $size
	 * @param $dec
	 * @param $separate
	 * --------------------------------------------------
	 */
	static public function getByteFormat($size, $dec = -1, $separate = false)
	{
		$units = array('B', 'KB', 'MB', 'GB', 'TB', 'PB');
		$digits = ($size == 0) ? 0 : floor(log($size, 1024));

		$over = false;
		$max_digit = count($units) - 1;

		if ($digits == 0) {
			$num = $size;
		} else if (!isset($units[$digits])) {
			$num = $size / (pow(1024, $max_digit));
			$over = true;
		} else {
			$num = $size / (pow(1024, $digits));
		}

		if ($dec > -1 && $digits > 0) $num = sprintf("%.{$dec}f", $num);
		if ($separate && $digits > 0) $num = number_format($num, $dec);

		return ($over) ? $num . $units[$max_digit] : $num . $units[$digits];
	}


	/**
	 * ==================================================
	 * security
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param int $length
	 * --------------------------------------------------
	 */
	static public function createRandomKey($length = 64)
	{
		$result = Str::random($length);

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	static public function createHashKey($keys)
	{
		$result = md5(implode('&', $keys));

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $keys
	 * --------------------------------------------------
	 */
	static public function getAgent($request)
	{
		// initialized
		$result = [];

		// create object
		$agent = new Agent();

		$device = $agent->device();
		$platform = $agent->platform();
		$platform_version = $agent->version($platform);
		$browser = $agent->browser();
		$browser_version = $agent->version($browser);
		$is_mobile = (int)$agent->isMobile();
		$is_tablet = (int)$agent->isTablet();
		$is_desktop = (int)$agent->isDesktop();
		$is_robot = (int)$agent->isRobot();
		$ip = $request->ip();
		$host = gethostbyaddr($ip);

		$result = [
			'agent_device' => $device,
			'agent_platform' => $platform,
			'agent_platform_version' => $platform_version,
			'agent_browser' => $browser,
			'agent_browser_version' => $browser_version,
			'agent_ip' => $ip,
			'agent_host' => $host,
			'is_agent_mobile' => $is_mobile,
			'is_agent_tablet' => $is_tablet,
			'is_agent_desktop' => $is_desktop,
			'is_agent_robot' => $is_robot,
		];

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function redirectError($patient_code, $error_code)
	{
		return redirect()->action('Frontend\ErrorController@index', [
			$patient_code,
			$error_code,
		]);

		//echo '<pre>';print_r($result);die();
		return $result;
	}


	/**
	 * ==================================================
	 * define
	 * ==================================================
	 */

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function setHourList()
	{
		$result = [];

		$array = [
			8, 9, 10, 11, 13, 14, 15, 16,
		];

		foreach ($array as $key => $value) {

			$result[$value] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function setMinuteList()
	{
		$result = [];

		$array = [
			0, 15, 30, 45,
		];

		foreach ($array as $key => $value) {

			$result[$value] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function getAcceptedNumberList($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		foreach ($data as $key => $value) {

			$result[$value['hh']][$value['ii']] = $value['accepted_number'];
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function getEnabledTimeList11111($data)
	{
		// initialized
		$result = [];

		foreach ($data as $key => $value) {

			if ($value['accepted_number'] != 0) $result[$key] = $value;
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function getEnabledTimeList($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		foreach ($data as $key => $value) {
			//echo '<pre>';print_r($value);die();

			if(!$value['is_disabled']) {

				$value['remain_number'] = (int)$value['accepted_number'] - (int)$value['booked_number'];
				//echo '<pre>';print_r($value['remain_number']);die();

				$result[] = $value;
			}
		}

		//foreach ($data as $key => $value) {
		//	//echo '<pre>';print_r($value);die();

		//	// set remain_number
		//	$value['remain_number'] = (int)$value['accepted_number'] - (int)$value['booked_number'];

		//	$result[self::getMeridiem($value['hh'], $value['ii'])][] = $value;
		//}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function getVaccine($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [
			'mtb_vaccine_id' => null,
			'vaccine_label' => null,
		];

		if(!is_null($data)) {

			$result = [
				'mtb_vaccine_id' => $data['mtb_vaccine_id'],
				'vaccine_label' => $data['vaccine_label'],
			];
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $error_code
	 * --------------------------------------------------
	 */
	static public function getTimeDropdownList($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		foreach($data as $key => $value) {

			$hh = $value[0];
			$ii = $value[1];

			$result[$hh] = implode('〜', [
				$hh . '時',
				($hh + 1) . '時',
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param Carbon\Carbon $booking_date
	 * @param Carbon\Carbon $birthday
	 * @param boolean $is_staff
	 * @param boolean $is_disease
	 * @return array $has_eligibility, $err_messages
	 * --------------------------------------------------
	 */
	// check eligibility special case 2023 spring
	static public function hasEligibilitySpecialCase2023Spring($booking_date, $birthday, $is_staff, $is_disease)
	{
		$start_at = Carbon::create(2023, 5, 8);
		//$end_at = Carbon::create(2023, 8, 31);

		// updated at 2023.08.09
		$date_end = Carbon::create(2023, 9, 19);

		$is_specialcase = $booking_date->between($start_at, $end_at);
		$is_senior = $birthday->diffInYears($booking_date) >= 65;

		$has_eligibility = $is_specialcase
			? ($is_staff || $is_senior || $is_disease)
			: true;

		$err_messages = $has_eligibility
			? []
			: [
				'令和5春開始接種(5月8日〜9月19日)の対象外です。',
				'<br>',
				'初回接種(1・2回目接種)を終了した以下の方が対象となります。',
				'・高齢者(65歳以上)',
				'・基礎疾患を有する方(12-64歳)',
				'・医療従事者・介護従事者',
			];
		return array($has_eligibility, $err_messages);
	}

	/**
	 * --------------------------------------------------
	 * @param object $date_booking
	 * @param object $birthday
	 * --------------------------------------------------
	 */
	static public function getIsDisabledAge($date_booking, $birthday)
	{
		//echo '<pre>';print_r($date_booking);die();
		//echo '<pre>';print_r($birthday);die();

		// initialized
		$result = false;

		// set min_age
		$min_age = 12;

		if($birthday->diffInYears($date_booking) < $min_age) $result = true;

		//echo '<pre>';var_dump($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param object $date_booking
	 * @param object $date_last
	 * --------------------------------------------------
	 */
	static public function getIsAvailableDate($date_booking, $date_last)
	{
		//echo '<pre>';print_r($booking);die();
		//echo '<pre>';print_r($date_last);die();

		// initialized
		$result = false;

		// get date_available
		$date_available = $date_last->addMonths(3);
		//echo '<pre>';print_r($date_available);die();

		if($date_available->gt($date_booking)) $result = true;

		//echo '<pre>';var_dump($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param object $date_booking
	 * @param object $birthday
	 * @param array $booking
	 * --------------------------------------------------
	 */
	static public function getIsSpecialCase($date_booking, $birthday, $booking)
	{
		//echo '<pre>';print_r($date_booking);die();
		//echo '<pre>';print_r($birthday);die();
		//echo '<pre>';print_r($booking);die();

		// initialized
		$result = false;

		$min_age = 65;
		$date_start = Carbon::create(2023, 5, 8);
		//$date_end = Carbon::create(2023, 8, 31);

		// updated at 2023.08.09
		$date_end = Carbon::create(2023, 9, 19);

		$is_specialcase = $date_booking->between($date_start, $date_end);
		//echo '<pre>';var_dump($is_specialcase);die();

		if($is_specialcase) {

			$diff_age = $birthday->diffInYears($date_booking);

			if($min_age > $diff_age) $result = true;
		}

		//echo '<pre>';var_dump($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param string $qr_number
	 * --------------------------------------------------
	 */
	static public function analyzeQrNumber($qr_number)
	{
		//echo '<pre>';print_r($qr_number);die();

		// initialized
		$result = [];

		$result = [
			'qr_number' => $qr_number,
			'voucher_number' => mb_substr($qr_number, 8, 10),
			'number1' => mb_substr($qr_number, 0, 1),
			'number2' => mb_substr($qr_number, 1, 1),
			'number3' => mb_substr($qr_number, 2, 6),
		];

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function createSearchKey($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		$result = array_merge($result, [
			['is_booked', '=', 1]
		]);

		if(!is_null($data['booking']['yy'])) {
			$result = array_merge($result, [
				['yy', '=', $data['booking']['yy']],
			]);
		}

		if(!is_null($data['booking']['mm'])) {
			$result = array_merge($result, [
				['mm', '=', $data['booking']['mm']],
			]);
		}

		if(!is_null($data['booking']['dd'])) {
			$result = array_merge($result, [
				['dd', '=', $data['booking']['dd']],
			]);
		}

		if(!is_null($data['booking']['mobile'])) {
			$result = array_merge($result, [
				['mobile', 'like', "%{$data['booking']['mobile']}%"],
			]);
		}

		if(!is_null($data['booking']['tel'])) {
			$result = array_merge($result, [
				['tel', 'like', "%{$data['booking']['tel']}%"],
			]);
		}

		if(!is_null($data['booking']['patient_skana'])) {
			$result = array_merge($result, [
				['patient_skana', 'like', "%{$data['booking']['patient_skana']}%"],
			]);
		}

		if(!is_null($data['booking']['patient_gkana'])) {
			$result = array_merge($result, [
				['patient_gkana', 'like', "%{$data['booking']['patient_gkana']}%"],
			]);
		}

		// birthday
		if(!is_null($data['birthday']['yy']) && !is_null($data['birthday']['mm']) && !is_null($data['birthday']['dd'])) {
			$result = array_merge($result, [
				['birthday', '=', Carbon::create(
					$data['birthday']['yy'],
					$data['birthday']['mm'],
					$data['birthday']['dd']
				)->toDateString()]
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function getWarekiYear($year = 1900)
	{
		$result = [];

		for($i = $year; $i <= date('Y'); $i++) {
			//echo '<pre>';print_r($i);die();

			$wareki = self::getWarekiDate($i);
			//echo '<pre>';print_r($wareki);die();

			$result[$i] = implode('', [
				$i,
				"（{$wareki}）",
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function getWarekiDate($yy)
	{
		// initialized
		$result = null;

		// set
		$wareki_list = [
			[
				'year' => 2018,
				'name' => '令和',
			],
			[
				'year' => 1988,
				'name' => '平成',
			],
			[
				'year' => 1925,
				'name' => '昭和',
			],
			[
				'year' => 1911,
				'name' => '大正'
			],
			[
				'year' => 1867,
				'name' => '明治',
			],
		];

		foreach($wareki_list as $i => $wareki) {

			$year = $wareki['year'];
			$name = $wareki['name'];

			if($yy > $year) {

				$diff_year = $yy - $year;

				if($diff_year === 1) {

					return implode('', [
						$wareki_list[($i + 1)]['name'],
						$yy - $wareki_list[($i + 1)]['year'],
						' / ',
						$name,
						'元',
					]);
				}

				return implode('', [
					$name,
					$diff_year,
				]);
				//return $name . $diff_year .'年';
			}
		}

		return null;
	}



	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function convertWareki($yy)
	{
		// initialized
		$result = null;

		// set
		$wareki_list = [
			[
				'year' => 2018,
				'name' => '令和',
			],
			[
				'year' => 1988,
				'name' => '平成',
			],
			[
				'year' => 1925,
				'name' => '昭和',
			],
			[
				'year' => 1911,
				'name' => '大正'
			],
			[
				'year' => 1867,
				'name' => '明治',
			],
		];

		foreach($wareki_list as $i => $wareki) {

			$year = $wareki['year'];
			$name = $wareki['name'];

			if($yy > $year) {

				$diff_year = $yy - $year;

				if($diff_year === 1) {

					return [
						'name' => $name,
						'year' => '元',
					];
				}

				return [
					'name' => $name,
					'year' => $diff_year,
				];
			}
		}

		return null;
	}

	/**
	 * --------------------------------------------------
	 * @param string $mobile
	 * @param string $message
	 * --------------------------------------------------
	 */
	static public function sendVonage($mobile, $message)
	{
		// create vonage object
		$basic = new \Vonage\Client\Credentials\Basic(
			Config::get('consts.vonage.vonage_key'),
			Config::get('consts.vonage.vonage_secret')
		);
		$client = new \Vonage\Client($basic);
		//echo '<pre>';print_r($client);die();

		// set to
		$to = implode('', [
			'81',
			$mobile,
		]);
		//echo '<pre>';print_r($to);die();

		$response = $client->sms()->send(
			new \Vonage\SMS\Message\SMS(
				$to,
				'HEIWADAI',
				$message,
				'unicode'
			)
		);
		return $response;
	}

	/**
	 * --------------------------------------------------
	 * @param string $mobile
	 * @param string $message
	 * --------------------------------------------------
	 */
	static public function sendMediasms($mobile, $message)
	{
		$response = Http::withBasicAuth(
			Config::get('consts.mediasms.username'),
			Config::get('consts.mediasms.password')
		)->post(
			Config::get('consts.mediasms.send_endpoint'),
			[
				"mobilenumber" => $mobile,
				"smstext" => $message,
			]
		);

		$result = $response->status();

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function getCountList($data)
	{
		$result = [
			'web' => 0,
			'tel' => 0,
			'leave' => 0,
		];

		foreach($data as $key => $value) {

			if($value['is_booked']) {

				if($value['is_web']) {

					$result['web'] += 1;
				}

				else {

					$result['tel'] += 1;
				}
			}

			else {

				$result['leave'] += 1;
			}
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function getTimelineList($data)
	{
		//echo '<pre>';print_r($data);die();

		// initialized
		$result = [];

		foreach($data as $key => $value) {
			//echo '<pre>';print_r($value);die();

			$result[] = implode(':', [
				sprintf('%02d', $value[0]),
				sprintf('%02d', $value[1]),
			]);
		}

		//echo '<pre>';print_r($result);die();
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function setIsForm($data)
	{
		// dd(session()->all());

		// set result
		$result = 1;

		// dd(session()->get('booking.address1'));
		if (session()->get('booking.address1') != '我孫子市') {

			// dd(session()->get('booking.age'));
			if (session()->get('booking.age') >= 65) {

				$result = 0;
			}

			else {

				if ((session()->get('booking.age') >= 60 && session()->get('booking.age') <= 64) && session()->get('booking.is_disease')) {
					
					$result = 0;
				}
			}
		}

		// set session
		session()->put('booking.is_form', $result);
		// dd(session()->all());

		// dd($result);
		return $result;
	}

	/**
	 * --------------------------------------------------
	 * @param array $data
	 * --------------------------------------------------
	 */
	static public function getIsPDF($data)
	{
		// dd($data);

		// set result
		$result = 1;

		if ($data['address1'] != '我孫子市') {

			if ($data['age'] >= 65) {

				$result = 0;
			}

			else {

				if (($data['age'] >= 60 && $data['age'] <= 64) && $data['is_disease']) {
					
					$result = 0;
				}
			}
		}

		return $result;
	}
}
