<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use Carbon\Carbon,
    Config,
    Session,
    App\Helper;

// use services
use App\Services\ServiceInterface,
    App\Services\MasterInterface,
    App\Services\BookingInterface;
use PhpOffice\PhpSpreadsheet\Calculation\Logical\Boolean;

class AjaxController extends Controller
{
    protected
        $service,
        $master,
        $booking;

    public function __construct(
        ServiceInterface $service,
        MasterInterface $master,
        BookingInterface $booking
    ) {
        parent::__construct();

        $this->service = $service;
        $this->master = $master;
        $this->booking = $booking;
    }

    public function voucherNumberExists(string $voucher_number)
    {
        // get booking
        $booking = $this->booking->getBooking(
            $keys = [
                ['voucher_number', '=', $voucher_number],
            ],
        );

        $result = [
            "is_exist" => empty($booking) ? false : true
        ];

        return response()->json($result, 200);
    }
}
