<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class IsCheckedinController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{

	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(string $booking_code, int $is_checkedin = 1)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'booking_code' => $booking_code,
			'is_checkedin' => $is_checkedin,
		];
		//echo '<pre>';print_r($data);die();

		// get booking
		$booking = $this->service->getFirst(
			$keys = [
				'booking_code' => $data['booking_code'],
			],
			$table = 'dtb_booking'
		);

		if($booking) {

			// initialized
			$values = [
				'is_checkedin' => $data['is_checkedin'],
			];

			if(is_null($booking['timestamp_checkedin'])) {

				$values = array_merge($values, [
					'timestamp_checkedin' => Carbon::now()->toDateTimeString(),
				]);
			}

			// get result
			$result = $this->service->updateRow(
				$keys = [
					'booking_code' => $data['booking_code'],
				],
				$values,
				$table = 'dtb_booking'
			);
			//echo '<pre>';print_r($result);die();

			return response()->json($result, 200);
		}

		return;
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
