<?php

namespace App\Http\Controllers\Ajax;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface;

class TimeController extends Controller
{
	protected
		$service,
		$master;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index($yy = null, $mm = null, $dd = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => $yy,
			'mm' => $mm,
			'dd' => $dd,
		];
		//echo '<pre>';print_r($data);die();

		// get result
		$result = $this->master->getEnabledTimeList(
			$keys = [
				'yy' => $data['yy'],
				'mm' => $data['mm'],
				'dd' => $data['dd'],
				'is_booked' => 1,
			]
		);
		//echo '<pre>';print_r($result);die();

        return response()->json($result, 200);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
