<?php

namespace App\Http\Controllers\Backend\Covid\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use LynX39\LaraPdfMerger\Facades\PdfMerger as PDFMerger;

// use components
use Config,
	DB,
	File,
	Session,
	Storage,
	Carbon\Carbon,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface,
	App\Services\FileInterface;

class BulkController extends Controller
{
	protected
		$service,
		$master,
		$booking,
		$file;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking,
		FileInterface $file
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
		$this->file = $file;
	}

	/**
	 * Display a listing of the resource.
	 */
	public function index()
	{
		// 
	}

	/**
	 * Show the form for creating a new resource.
	 */
	public function create()
	{
		// 
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		// initialized
		$data = [];

		// get request
		$data = $request->all();
		// dd($data);

		if (isset($data['bulk'])) {

			// get booking_list
			$booking_list = $this->service->getList(
				$keys = [
					['yy', '=', $data['yy']],
					['mm', '=', $data['mm']],
					['dd', '=', $data['dd']],
					['is_booked', '=', 1],
					['address1', '=', '我孫子市'],
				],
				$orders = [
					'patient_skana' => 'ASC',
				],
				$table = 'dtb_booking'
			);
			// dd($booking_list);

			foreach ($booking_list as $booking) {
				// dd($booking);

				// get file_path
				$file_path = storage_path(implode('/', [
					'app',
					'public',
					'pdf',
					$data['yy'],
					Carbon::create($data['yy'], $data['mm'], $data['dd'])->format('md'),
					$booking['signin_code'] . '.pdf',
				]));
				// dd($file_path);

				if (!File::exists($file_path)) {
					// dd('create pdf');

					// get booking
					$data['booking'] = $this->booking->getBooking(
						$keys = [
							['dtb_booking.booking_code', '=', $booking['booking_code']],
						]
					);
					// dd($data['booking']);

					$data['booking']['patient_name'] = implode('　', [
						$data['booking']['patient_sname'],
						$data['booking']['patient_gname'],
					]);
			
					$data['booking']['patient_kana'] = implode('　', [
						$data['booking']['patient_skana'],
						$data['booking']['patient_gkana'],
					]);
			
					$data['booking']['wareki'] = Helper::convertWareki(Carbon::parse($data['booking']['birthday'])->year);
			
					$data['booking']['age'] = Helper::getAge($data['booking']['birthday']);
			
					// if (strlen($data['booking']['mobile']) == 11) {
			
					// 	$data['booking']['mobile'] = [
					// 		substr($data['booking']['mobile'], 0, 3),
					// 		substr($data['booking']['mobile'], 3, 4),
					// 		substr($data['booking']['mobile'], 7, 4),
					// 	];
					// }
					// else {
			
					// 	$data['booking']['mobile'] = [
					// 		substr($data['booking']['mobile'], 0, 2),
					// 		substr($data['booking']['mobile'], 2, 4),
					// 		substr($data['booking']['mobile'], 6),
					// 	];
					// }
			
					// get form_list
					$data['form_list'] = $this->service->getList(
						$keys = [
							['dtb_booking_id', '=', $data['booking']['dtb_booking_id']],
						],
						$orders = [
							'mtb_form_id' => 'ASC',
						],
						$table = 'dtb_form'
					);

					// dd($data);
					$this->file->CreateFormPDF($data);
					// dd('pdf is created');
				}
			}
			// dd('ok');

			/**
			 * 
			 */

			// initialized
			$file_list = [];

			// get dir_path
			$dir_path = implode('/', [
				'public',
				'pdf',
				$data['yy'],
				Carbon::create($data['yy'], $data['mm'], $data['dd'])->format('md'),
			]);
			// dd($dir_path);

			foreach ($booking_list as $booking) {
				// dd($booking);

				foreach ($data['bulk'] as $key => $value) {
					
					// if (isset($data['bulk'][$booking['signin_code']])) {
					if ($booking['signin_code'] == $value) {
						// dd($booking);
	
						$file_list[] = implode('/', [
							$dir_path,
							$booking['signin_code'] . '.pdf',
						]);
					}
				}
			}
			// dd('ok');

			// get file_list
			// $file_list = Storage::files($dir_path);
			// dd($file_list);
			
			// create instance
			$pdfMerger = PdfMerger::init();
			// dd('ok');
			
			foreach ($file_list as $file) {
				
				$file_path = storage_path(implode('/', [
					'app',
					$file,
				]));
				// dd($file_path);

				if (File::exists($file_path)) $pdfMerger->addPDF(Storage::path($file));
			}

			$pdfMerger->merge();
			$pdfMerger->save('merge.pdf', 'browser');

			unset($pdfMerger);
		}

		return;
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
