<?php

namespace App\Http\Controllers\Backend\Covid;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use components
use	Carbon\Carbon,
	Config,
	Session,
	App\Helper;

// use services
use App\Services\ServiceInterface,
	App\Services\MasterInterface,
	App\Services\BookingInterface;

class CalendarController extends Controller
{
	protected
		$service,
		$master,
		$booking;

	public function __construct(
		ServiceInterface $service,
		MasterInterface $master,
		BookingInterface $booking
	) {
		parent::__construct();

		$this->service = $service;
		$this->master = $master;
		$this->booking = $booking;
	}

	/**
	 * Display a listing of the resource.
	 *
	 * @param int $yy
	 * @param int $mm
	 * @param int $mtb_vaccine_id
	 */
	public function index($yy = null, $mm = null, $mtb_vaccine_id = null)
	{
		// initialized
		$data = [];

		// get parameeters
		$data = [
			'yy' => (is_null($yy)) ? date('Y') : $yy,
			'mm' => (is_null($mm)) ? date('n') : $mm,
			'mtb_vaccine_id' => $mtb_vaccine_id,
		];
		//echo '<pre>';print_r($data);die();

		// get date
		$data['date'] = [
			'prev' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->subMonth(1)->toDateString()),
			'next' => Helper::getDate(Carbon::create($data['yy'], $data['mm'], 1)->addMonth(1)->toDateString()),
			'day' => Carbon::create($data['yy'], $data['mm'], 1)->endOfMonth()->format('j'),
			'week' => Carbon::create($data['yy'], $data['mm'], 1)->startOfMonth()->format('w'),
		];
		//echo '<pre>';print_r($data['date']);die();

		// get vaccine_list
		$data['vaccine_list'] = $this->master->getMasterDropdownList(
			$keys = [
				['is_disabled', '=', 0],
			],
			$orders = [
				'seq' => 'ASC',
			],
			$table = 'vaccine'
		);
		//echo '<pre>';print_r($data['vaccine_list']);die();

		// initialized
		$keys = [];

		if(!is_null($data['mtb_vaccine_id'])) {

			$keys = array_merge($keys, [
				'mtb_vaccine_id' => $data['mtb_vaccine_id'],
			]);
		}
		//echo '<pre>';print_r($keys);die();

		// get booking_list
		$data['booking_list'] = $this->booking->getBookingCountList(
			$keys = array_merge($keys, [
				'yy' => $data['yy'],
				'mm' => $data['mm'],
			])
		);
		//echo '<pre>';print_r($data['booking_list']);die();

		// get vaccine_list
		$data['vaccine_list'] = $this->master->getMasterDropdownList(
			$keys = [],
			$orders = [],
			$table = 'vaccine'
		);
		//echo '<pre>';print_r($data['vaccine_list']);die();

		// set title
		$data['title'] = __("lang.calendar.title");

		// get lang
		$data['lang'] = $this->lang;
		//echo '<pre>';print_r($data['lang']);die();

		// set tab
		$data['tab'] = 'calendar';

		//echo '<pre>';print_r($data);die();
		return view('backend.covid.calendar.index', $data);
	}

	/**
	 * Store a newly created resource in storage.
	 */
	public function store(Request $request)
	{
		//
	}

	/**
	 * Display the specified resource.
	 */
	public function show(string $id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 */
	public function update(Request $request, string $id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 */
	public function destroy(string $id)
	{
		//
	}
}
